/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import java.util.Locale;
import java.util.regex.Pattern;

public final class zzazf {
    private static final Pattern zzfbq = Pattern.compile("urn:x-cast:[-A-Za-z0-9_]+(\\.[-A-Za-z0-9_]+)*");

    public static <T> boolean zza(T t, T t2) {
        return t == null && t2 == null || t != null && t2 != null && t.equals(t2);
    }

    public static void zzfg(String string2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty");
        }
        if (string2.length() > 128) {
            throw new IllegalArgumentException("Invalid namespace length");
        }
        if (!string2.startsWith("urn:x-cast:")) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\"");
        }
        if (string2.length() == 11) {
            throw new IllegalArgumentException("Namespace must begin with the prefix \"urn:x-cast:\" and have non-empty suffix");
        }
    }

    public static String zzfh(String string2) {
        String string3 = String.valueOf("urn:x-cast:");
        String string4 = String.valueOf(string2);
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    public static String zzfi(String string2) {
        if (zzfbq.matcher(string2).matches()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            char c2 = c = string2.charAt(i);
            if (c >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '-' || c == '.' || c == ':') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(String.format("%%%04x", c & 0xFFFF));
        }
        return stringBuilder.toString();
    }

    public static String zzb(Locale locale) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(locale.getLanguage());
        String string3 = locale.getCountry();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append('-').append(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = locale.getVariant()))) {
            stringBuilder.append('-').append(string2);
        }
        return stringBuilder.toString();
    }
}

