/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzc;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AdBreakStatus
extends zzbfm {
    public static final Parcelable.Creator<AdBreakStatus> CREATOR = new zzc();
    public static final int AD_BREAK_CLIP_NOT_SKIPPABLE = -1;
    private final long zzenc;
    private final long zzend;
    private final String zzene;
    private final String zzenf;
    private final long zzeng;

    AdBreakStatus(long l, long l2, String string, String string2, long l3) {
        this.zzenc = l;
        this.zzend = l2;
        this.zzene = string;
        this.zzenf = string2;
        this.zzeng = l3;
    }

    public String getBreakId() {
        return this.zzene;
    }

    public String getBreakClipId() {
        return this.zzenf;
    }

    public long getCurrentBreakTimeInMs() {
        return this.zzenc;
    }

    public long getCurrentBreakClipTimeInMs() {
        return this.zzend;
    }

    public long getWhenSkippableInMs() {
        return this.zzeng;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        AdBreakStatus adBreakStatus = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)adBreakStatus.getCurrentBreakTimeInMs());
        zzbfp.zza((Parcel)parcel2, (int)3, (long)adBreakStatus.getCurrentBreakClipTimeInMs());
        zzbfp.zza((Parcel)parcel2, (int)4, (String)adBreakStatus.getBreakId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)adBreakStatus.getBreakClipId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (long)adBreakStatus.getWhenSkippableInMs());
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzenc, this.zzend, this.zzene, this.zzenf, this.zzeng});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AdBreakStatus)) {
            return false;
        }
        AdBreakStatus adBreakStatus = (AdBreakStatus)((Object)object);
        return this.zzenc == adBreakStatus.zzenc && this.zzend == adBreakStatus.zzend && zzbcm.zza(this.zzene, adBreakStatus.zzene) && zzbcm.zza(this.zzenf, adBreakStatus.zzenf) && this.zzeng == adBreakStatus.zzeng;
    }

    static AdBreakStatus zzs(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (!jSONObject.has("currentBreakTime") || !jSONObject.has("currentBreakClipTime")) {
            return null;
        }
        try {
            long l = (long)((double)jSONObject.getLong("currentBreakTime") * 1000.0);
            long l2 = (long)((double)jSONObject.getLong("currentBreakClipTime") * 1000.0);
            String string = jSONObject.optString("breakId", null);
            String string2 = jSONObject.optString("breakClipId", null);
            long l3 = jSONObject.optLong("whenSkippable", -1L);
            if (l3 != -1L) {
                l3 = (long)((double)l3 * 1000.0);
            }
            return new AdBreakStatus(l, l2, string, string2, l3);
        }
        catch (JSONException jSONException) {
            Log.d((String)"AdBreakInfo", (String)String.format(Locale.ROOT, "Error while creating an AdBreakClipInfo from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

