/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzak;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zzbfm
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzak();
    private long zzebu;
    private int zzeie;
    private String zzeqc;
    private String zzeqe;
    private String mName;
    private String zzdrl;
    private int zzert;
    private String zzemx;
    private JSONObject zzemy;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zzebu = l;
        this.zzeie = n;
        this.zzeqc = string2;
        this.zzeqe = string3;
        this.mName = string4;
        this.zzdrl = string5;
        this.zzert = n2;
        this.zzemx = string6;
        if (this.zzemx != null) {
            try {
                this.zzemy = new JSONObject(this.zzemx);
                return;
            }
            catch (JSONException jSONException) {
                this.zzemy = null;
                this.zzemx = null;
                return;
            }
        }
        this.zzemy = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zzebu = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzeie = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzeie = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzeie = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzeqc = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzeqe = jSONObject2.optString("trackContentType", null);
                            mediaTrack.mName = jSONObject2.optString("name", null);
                            mediaTrack.zzdrl = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzert = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzert = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzert = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzert = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzert = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzert = 0;
        }
        mediaTrack.zzemy = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zzebu = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzeie = n;
    }

    public final long getId() {
        return this.zzebu;
    }

    public final int getType() {
        return this.zzeie;
    }

    public final String getContentId() {
        return this.zzeqc;
    }

    public final void setContentId(String string2) {
        this.zzeqc = string2;
    }

    public final String getContentType() {
        return this.zzeqe;
    }

    public final void setContentType(String string2) {
        this.zzeqe = string2;
    }

    public final String getName() {
        return this.mName;
    }

    final void setName(String string2) {
        this.mName = string2;
    }

    public final String getLanguage() {
        return this.zzdrl;
    }

    final void setLanguage(String string2) {
        this.zzdrl = string2;
    }

    public final int getSubtype() {
        return this.zzert;
    }

    final void zzbc(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzeie != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzert = n;
    }

    public final JSONObject getCustomData() {
        return this.zzemy;
    }

    final void setCustomData(JSONObject jSONObject) {
        this.zzemy = jSONObject;
    }

    public final JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzebu);
            switch (this.zzeie) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzeqc != null) {
                jSONObject.put("trackContentId", (Object)this.zzeqc);
            }
            if (this.zzeqe != null) {
                jSONObject.put("trackContentType", (Object)this.zzeqe);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzdrl)) {
                jSONObject.put("language", (Object)this.zzdrl);
            }
            switch (this.zzert) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzemy != null) {
                jSONObject.put("customData", (Object)this.zzemy);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzemy == null != (mediaTrack.zzemy == null)) {
            return false;
        }
        if (this.zzemy != null && mediaTrack.zzemy != null && !zzo.zzc((Object)this.zzemy, (Object)mediaTrack.zzemy)) {
            return false;
        }
        return this.zzebu == mediaTrack.zzebu && this.zzeie == mediaTrack.zzeie && zzbcm.zza(this.zzeqc, mediaTrack.zzeqc) && zzbcm.zza(this.zzeqe, mediaTrack.zzeqe) && zzbcm.zza(this.mName, mediaTrack.mName) && zzbcm.zza(this.zzdrl, mediaTrack.zzdrl) && this.zzert == mediaTrack.zzert;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzebu, this.zzeie, this.zzeqc, this.zzeqe, this.mName, this.zzdrl, this.zzert, String.valueOf(this.zzemy)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzemx = this.zzemy == null ? null : this.zzemy.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzbfp.zzc((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzbfp.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzbfp.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzemx, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zzeru;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzeru = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzeru.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzeru.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzeru.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzeru.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzeru.setLanguage(zzbcm.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzeru.zzbc(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzeru.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzeru;
        }
    }
}

