/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbbc;
import com.google.android.gms.internal.zzbbe;
import com.google.android.gms.internal.zzbbf;
import com.google.android.gms.internal.zzbbg;
import com.google.android.gms.internal.zzbbo;
import com.google.android.gms.internal.zzbbp;
import com.google.android.gms.internal.zzbbq;
import com.google.android.gms.internal.zzbbr;
import com.google.android.gms.internal.zzbbs;
import com.google.android.gms.internal.zzbbw;
import com.google.android.gms.internal.zzbcm;
import com.google.android.gms.internal.zzbcy;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbde;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbbb
extends zzbbw {
    private static String NAMESPACE = zzbcm.zzfo("com.google.cast.games");
    private static final zzbcy zzeow = new zzbcy("GameManagerChannel");
    private final Map<String, String> zzfef = new ConcurrentHashMap<String, String>();
    private final List<zzbde> zzfeg;
    private final SharedPreferences zzbhh;
    private final String zzfeh;
    private final Cast.CastApi zzeul;
    private final GoogleApiClient zzezn;
    private zzbbo zzfei;
    private boolean zzfej = false;
    private GameManagerState zzfek;
    private GameManagerState zzfel;
    private String zzfem;
    private JSONObject zzfen;
    private long zzfeo = 0L;
    private GameManagerClient.Listener zzfep;
    private final zzd zzata;
    private String zzfeq;

    public zzbbb(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzata = zzh.zzamg();
        this.zzfeg = new ArrayList<zzbde>();
        this.zzfeh = string2;
        this.zzeul = castApi;
        this.zzezn = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzbhh = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzfel = null;
        this.zzfek = new zzbbq(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        return this.zzezn.zze((zzm)new zzbbc(this, gameManagerClient));
    }

    public final synchronized void dispose() throws IllegalStateException {
        if (this.zzfej) {
            return;
        }
        this.zzfek = null;
        this.zzfel = null;
        this.zzfem = null;
        this.zzfen = null;
        this.zzfej = true;
        try {
            this.zzeul.removeMessageReceivedCallbacks(this.zzezn, this.getNamespace());
            return;
        }
        catch (IOException iOException) {
            zzeow.zzf("Exception while detaching game manager channel.", iOException);
            return;
        }
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> zza(String string2, int n, JSONObject jSONObject) throws IllegalStateException {
        this.zzaez();
        return this.zzezn.zze((zzm)new zzbbe(this, n, string2, jSONObject));
    }

    public final synchronized void sendGameMessage(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzaez();
        long l = ++this.zzfeo;
        JSONObject jSONObject2 = this.zza(l, string2, 7, jSONObject);
        if (jSONObject2 == null) {
            return;
        }
        this.zzeul.sendMessage(this.zzezn, this.getNamespace(), jSONObject2.toString());
    }

    public final synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(String string2, JSONObject jSONObject) throws IllegalStateException {
        this.zzaez();
        return this.zzezn.zze((zzm)new zzbbf(this, string2, jSONObject));
    }

    public final synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzaez();
        return this.zzfek;
    }

    public final synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzaez();
        return this.zzfeq;
    }

    private final synchronized String zzfl(String string2) throws IllegalStateException {
        if (string2 == null) {
            return null;
        }
        return this.zzfef.get(string2);
    }

    public final synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzfep = listener;
    }

    @Override
    public final void zzfm(String string2) {
        int n;
        zzbbp zzbbp2;
        zzeow.zzb("message received: %s", string2);
        try {
            zzbbp2 = zzbbp.zzx(new JSONObject(string2));
        }
        catch (JSONException jSONException) {
            zzeow.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzbbp2 == null) {
            zzeow.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzbbp2.zzfei == null || this.isDisposed()) {
            return;
        }
        boolean bl = zzbbp2.zzffh == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzbbp2.zzffo)) {
            this.zzfef.put(zzbbp2.zzffb, zzbbp2.zzffo);
            this.zzafa();
        }
        if (zzbbp2.zzcd == 0) {
            this.zza(zzbbp2);
        } else {
            zzeow.zzf("Not updating from game message because the message contains error code: %d", zzbbp2.zzcd);
        }
        int n2 = zzbbp2.zzcd;
        switch (n2) {
            case 4: {
                int n3 = 2151;
                break;
            }
            case 3: {
                int n3 = 2150;
                break;
            }
            case 2: {
                int n3 = 2003;
                break;
            }
            case 1: {
                int n3 = 2001;
                break;
            }
            case 0: {
                int n3 = 0;
                break;
            }
            default: {
                zzeow.zzf(new StringBuilder(53).append("Unknown GameManager protocol status code: ").append(n2).toString(), new Object[0]);
                int n3 = n = 13;
            }
        }
        if (bl) {
            this.zzb(zzbbp2.zzffc, n, zzbbp2);
        }
        if (this.isInitialized() && n == 0) {
            zzbbb zzbbb2 = this;
            if (zzbbb2.zzfep != null) {
                if (zzbbb2.zzfel != null && !zzbbb2.zzfek.equals(zzbbb2.zzfel)) {
                    zzbbb2.zzfep.onStateChanged(zzbbb2.zzfek, zzbbb2.zzfel);
                }
                if (zzbbb2.zzfen != null && zzbbb2.zzfem != null) {
                    zzbbb2.zzfep.onGameMessageReceived(zzbbb2.zzfem, zzbbb2.zzfen);
                }
            }
            zzbbb2.zzfel = null;
            zzbbb2.zzfem = null;
            zzbbb2.zzfen = null;
        }
    }

    public final synchronized boolean isDisposed() {
        return this.zzfej;
    }

    private final synchronized boolean isInitialized() {
        return this.zzfei != null;
    }

    @Override
    public final void zzc(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zzz(long l) {
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzbde.zzakl;
        synchronized (object) {
            Iterator<zzbde> iterator2 = this.zzfeg.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzaft()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private final synchronized void zzaez() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private final void zza(String string2, int n, JSONObject jSONObject, zzbdd zzbdd2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzfeo, string2, n, jSONObject)) == null) {
            zzbdd2.zza(-1L, 2001, null);
            zzeow.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzbde zzbde2 = new zzbde(this.zzata, 30000L);
        zzbde2.zza(l, zzbdd2);
        this.zzfeg.add(zzbde2);
        this.zzbc(true);
        this.zzeul.sendMessage(this.zzezn, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new zzbbg(this, l));
    }

    private final JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzfl(string2));
        }
        catch (JSONException jSONException) {
            zzeow.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private final synchronized void zza(zzbbp zzbbp2) {
        boolean bl = zzbbp2.zzffh == 1;
        this.zzfel = this.zzfek;
        if (bl && zzbbp2.zzfei != null) {
            this.zzfei = zzbbp2.zzfei;
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzbbs zzbbs2 : zzbbp2.zzffl) {
            String string2 = zzbbs2.getPlayerId();
            zzbbr zzbbr2 = new zzbbr(string2, zzbbs2.getPlayerState(), zzbbs2.getPlayerData(), this.zzfef.containsKey(string2));
            arrayList.add(zzbbr2);
        }
        this.zzfek = new zzbbq(zzbbp2.zzffk, zzbbp2.zzffj, zzbbp2.zzffn, zzbbp2.zzffm, arrayList, this.zzfei.zzafd(), this.zzfei.getMaxPlayers());
        PlayerInfo playerInfo = this.zzfek.getPlayer(zzbbp2.zzffb);
        if (playerInfo != null && playerInfo.isControllable() && zzbbp2.zzffh == 2) {
            this.zzfem = zzbbp2.zzffb;
            this.zzfen = zzbbp2.zzffd;
        }
    }

    private final void zzb(long l, int n, Object object) {
        Iterator<zzbde> iterator = this.zzfeg.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private final synchronized void zzafa() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzfeh);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzfef));
            this.zzbhh.edit().putString("save_data", jSONObject.toString()).commit();
            return;
        }
        catch (JSONException jSONException) {
            zzeow.zzf("Error while saving data: %s", jSONException.getMessage());
            return;
        }
    }

    private final synchronized void zzafb() {
        String string2 = this.zzbhh.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzfeh.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzfef.put(string4, jSONObject2.getString(string4));
                }
                this.zzfeo = 0L;
            }
            return;
        }
        catch (JSONException jSONException) {
            zzeow.zzf("Error while loading data: %s", jSONException.getMessage());
            return;
        }
    }

    static /* synthetic */ GoogleApiClient zza(zzbbb zzbbb2) {
        return zzbbb2.zzezn;
    }

    static /* synthetic */ Cast.CastApi zzb(zzbbb zzbbb2) {
        return zzbbb2.zzeul;
    }

    static /* synthetic */ void zzc(zzbbb zzbbb2) {
        zzbbb2.zzafb();
    }

    static /* synthetic */ void zzd(zzbbb zzbbb2) {
        zzbbb2.zzafa();
    }

    static /* synthetic */ void zza(zzbbb zzbbb2, String string2, int n, JSONObject jSONObject, zzbdd zzbdd2) {
        zzbbb2.zza(string2, n, jSONObject, zzbdd2);
    }

    static /* synthetic */ zzbcy zzafc() {
        return zzeow;
    }

    static /* synthetic */ zzbbo zza(zzbbb zzbbb2, zzbbo zzbbo2) {
        zzbbb2.zzfei = null;
        return null;
    }

    static /* synthetic */ String zza(zzbbb zzbbb2, String string2) {
        zzbbb2.zzfeq = string2;
        return zzbbb2.zzfeq;
    }
}

