/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.NotificationCompat;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.Display;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.CastMediaControlIntent;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayClient;
import com.google.android.gms.cast.zzaa;
import com.google.android.gms.cast.zzu;
import com.google.android.gms.cast.zzv;
import com.google.android.gms.cast.zzw;
import com.google.android.gms.cast.zzx;
import com.google.android.gms.cast.zzy;
import com.google.android.gms.cast.zzz;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.tasks.OnCompleteListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

@TargetApi(value=19)
public abstract class CastRemoteDisplayLocalService
extends Service {
    private static final zzbei zza = new zzbei("CastRemoteDisplayLocalService");
    private static final int zzb = R.id.cast_notification_id;
    private static final Object zzc = new Object();
    private static AtomicBoolean zzd = new AtomicBoolean(false);
    private String zze;
    private WeakReference<Callbacks> zzf;
    private zzb zzg;
    private NotificationSettings zzh;
    private Notification zzi;
    private boolean zzj;
    private PendingIntent zzk;
    private CastDevice zzl;
    private Display zzm;
    private Context zzn;
    private ServiceConnection zzo;
    private Handler zzp;
    private MediaRouter zzq;
    private boolean zzr = false;
    private CastRemoteDisplayClient zzs;
    private final MediaRouter.Callback zzt = new zzu(this);
    private static CastRemoteDisplayLocalService zzu;
    private final IBinder zzv = new zza();

    public CastRemoteDisplayLocalService() {
    }

    public IBinder onBind(Intent intent) {
        this.zza("onBind");
        return this.zzv;
    }

    public void onCreate() {
        this.zza("onCreate");
        super.onCreate();
        this.zzp = new Handler(this.getMainLooper());
        this.zzp.postDelayed((Runnable)new zzv(this), 100L);
        if (this.zzs == null) {
            this.zzs = CastRemoteDisplay.getClient((Context)this);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (com.google.android.gms.common.util.zzs.zzi()) {
            NotificationManager notificationManager = (NotificationManager)castRemoteDisplayLocalService.getSystemService(NotificationManager.class);
            NotificationChannel notificationChannel = new NotificationChannel("cast_remote_display_local_service", (CharSequence)castRemoteDisplayLocalService.getString(R.string.cast_notification_default_channel_name), 2);
            notificationChannel.setShowBadge(false);
            notificationManager.createNotificationChannel(notificationChannel);
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.zza("onStartCommand");
        this.zzr = true;
        return 2;
    }

    protected static void setDebugEnabled() {
        zza.zza(true);
    }

    protected Display getDisplay() {
        return this.zzm;
    }

    public abstract void onCreatePresentation(Display var1);

    public abstract void onDismissPresentation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CastRemoteDisplayLocalService getInstance() {
        Object object = zzc;
        synchronized (object) {
            return zzu;
        }
    }

    public static void startService(Context context, Class<? extends CastRemoteDisplayLocalService> clazz, String string2, CastDevice castDevice, NotificationSettings notificationSettings, Callbacks callbacks) {
        CastRemoteDisplayLocalService.startServiceWithOptions(context, clazz, string2, castDevice, new Options(), notificationSettings, callbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServiceWithOptions(@NonNull Context context, @NonNull Class<? extends CastRemoteDisplayLocalService> clazz, @NonNull String string2, @NonNull CastDevice castDevice, @NonNull Options options, @NonNull NotificationSettings notificationSettings, @NonNull Callbacks callbacks) {
        zza.zza("Starting Service", new Object[0]);
        Object object = zzc;
        synchronized (object) {
            if (zzu != null) {
                zza.zzc("An existing service had not been stopped before starting one", new Object[0]);
                CastRemoteDisplayLocalService.zzc(true);
            }
        }
        Class<? extends CastRemoteDisplayLocalService> clazz2 = clazz;
        Context context2 = context;
        try {
            ComponentName componentName = new ComponentName(context2, clazz2);
            ServiceInfo serviceInfo = context2.getPackageManager().getServiceInfo(componentName, 128);
            if (serviceInfo != null && serviceInfo.exported) {
                throw new IllegalStateException("The service must not be exported, verify the manifest configuration");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("Service not found, did you forget to configure it in the manifest?");
        }
        zzbq.zza((Object)context, (Object)"activityContext is required.");
        zzbq.zza(clazz, (Object)"serviceClass is required.");
        zzbq.zza((Object)string2, (Object)"applicationId is required.");
        zzbq.zza((Object)((Object)castDevice), (Object)"device is required.");
        zzbq.zza((Object)options, (Object)"options is required.");
        zzbq.zza((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.zza((Object)callbacks, (Object)"callbacks is required.");
        if (notificationSettings.zza == null && notificationSettings.zzb == null) {
            throw new IllegalArgumentException("notificationSettings: Either the notification or the notificationPendingIntent must be provided");
        }
        if (zzd.getAndSet(true)) {
            zza.zzd("Service is already being started, startService has been called twice", new Object[0]);
            return;
        }
        object = new Intent(context, clazz);
        context.startService((Intent)object);
        context.bindService((Intent)object, (ServiceConnection)new zzw(string2, castDevice, options, notificationSettings, context, callbacks), 64);
    }

    private final void zzb(boolean bl) {
        this.zza("Stopping Service");
        zzbq.zzb((String)"stopServiceInstanceInternal must be called on the main thread");
        if (!bl && this.zzq != null) {
            this.zza("Setting default route");
            this.zzq.selectRoute(this.zzq.getDefaultRoute());
        }
        if (this.zzg != null) {
            this.zza("Unregistering notification receiver");
            this.unregisterReceiver(this.zzg);
        }
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zza("stopRemoteDisplaySession");
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        castRemoteDisplayLocalService2.zza("stopRemoteDisplay");
        castRemoteDisplayLocalService2.zzs.stopRemoteDisplay().addOnCompleteListener((OnCompleteListener)new zzaa(castRemoteDisplayLocalService2));
        if (castRemoteDisplayLocalService.zzf.get() != null) {
            ((Callbacks)castRemoteDisplayLocalService.zzf.get()).onRemoteDisplaySessionEnded(castRemoteDisplayLocalService);
        }
        castRemoteDisplayLocalService.onDismissPresentation();
        castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zza("Stopping the remote display Service");
        castRemoteDisplayLocalService.stopForeground(true);
        castRemoteDisplayLocalService.stopSelf();
        castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzq != null) {
            zzbq.zzb((String)"CastRemoteDisplayLocalService calls must be done on the main thread");
            castRemoteDisplayLocalService.zza("removeMediaRouterCallback");
            castRemoteDisplayLocalService.zzq.removeCallback(castRemoteDisplayLocalService.zzt);
        }
        if (this.zzn != null && this.zzo != null) {
            try {
                this.zzn.unbindService(this.zzo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.zza("No need to unbind service, already unbound");
            }
            this.zzo = null;
            this.zzn = null;
        }
        this.zze = null;
        this.zzi = null;
        this.zzm = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zzc(boolean bl) {
        CastRemoteDisplayLocalService castRemoteDisplayLocalService;
        zza.zza("Stopping Service", new Object[0]);
        zzd.set(false);
        Object object = zzc;
        synchronized (object) {
            if (zzu == null) {
                zza.zzd("Service is already being stopped", new Object[0]);
                return;
            }
            castRemoteDisplayLocalService = zzu;
            zzu = null;
        }
        boolean bl2 = bl;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService2 = castRemoteDisplayLocalService;
        if (castRemoteDisplayLocalService2.zzp != null) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                castRemoteDisplayLocalService2.zzp.post((Runnable)new zzx(castRemoteDisplayLocalService2, bl2));
                return;
            }
            castRemoteDisplayLocalService2.zzb(bl2);
        }
    }

    public static void stopService() {
        CastRemoteDisplayLocalService.zzc(false);
    }

    public void updateNotificationSettings(NotificationSettings notificationSettings) {
        zzbq.zza((Object)notificationSettings, (Object)"notificationSettings is required.");
        zzbq.zza((Object)this.zzp, (Object)"Service is not ready yet.");
        this.zzp.post((Runnable)new zzy(this, notificationSettings));
    }

    private final void zza(NotificationSettings notificationSettings) {
        zzbq.zzb((String)"updateNotificationSettingsInternal must be called on the main thread");
        if (this.zzh == null) {
            throw new IllegalStateException("No current notification settings to update");
        }
        if (this.zzj) {
            if (notificationSettings.zza != null) {
                throw new IllegalStateException("Current mode is default notification, notification attribute must not be provided");
            }
            if (notificationSettings.zzb != null) {
                this.zzh.zzb = notificationSettings.zzb;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzc)) {
                this.zzh.zzc = notificationSettings.zzc;
            }
            if (!TextUtils.isEmpty((CharSequence)notificationSettings.zzd)) {
                this.zzh.zzd = notificationSettings.zzd;
            }
            this.zzi = this.zzd(true);
        } else {
            zzbq.zza((Object)notificationSettings.zza, (Object)"notification is required.");
            this.zzi = notificationSettings.zza;
            this.zzh.zza = this.zzi;
        }
        this.startForeground(zzb, this.zzi);
    }

    private final void zza(Display display) {
        this.zzm = display;
        if (this.zzj) {
            this.zzi = this.zzd(true);
            this.startForeground(zzb, this.zzi);
        }
        if (this.zzf.get() != null) {
            ((Callbacks)this.zzf.get()).onRemoteDisplaySessionStarted(this);
        }
        this.onCreatePresentation(this.zzm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        this.zza("startRemoteDisplaySession");
        zzbq.zzb((String)"Starting the Cast Remote Display must be done on the main thread");
        Object object = zzc;
        synchronized (object) {
            if (zzu != null) {
                zza.zzc("An existing service had not been stopped before starting one", new Object[0]);
                return false;
            }
            zzu = this;
        }
        this.zzf = new WeakReference<Callbacks>(callbacks);
        this.zze = string2;
        this.zzl = castDevice;
        this.zzn = context;
        this.zzo = serviceConnection;
        if (this.zzq == null) {
            this.zzq = MediaRouter.getInstance((Context)this.getApplicationContext());
        }
        object = new MediaRouteSelector.Builder().addControlCategory(CastMediaControlIntent.categoryForCast(this.zze)).build();
        this.zza("addMediaRouterCallback");
        this.zzq.addCallback((MediaRouteSelector)object, this.zzt, 4);
        this.zzi = notificationSettings.zza;
        this.zzg = new zzb(null);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
        intentFilter.addAction("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        this.registerReceiver(this.zzg, intentFilter);
        this.zzh = new NotificationSettings(notificationSettings, null);
        if (this.zzh.zza == null) {
            this.zzj = true;
            this.zzi = this.zzd(false);
        } else {
            this.zzj = false;
            this.zzi = this.zzh.zza;
        }
        this.startForeground(zzb, this.zzi);
        Options options2 = options;
        CastDevice castDevice2 = castDevice;
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        castRemoteDisplayLocalService.zza("startRemoteDisplay");
        Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED");
        intent.setPackage(castRemoteDisplayLocalService.zzn.getPackageName());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0);
        castRemoteDisplayLocalService.zzs.startRemoteDisplay(castDevice2, castRemoteDisplayLocalService.zze, options2.getConfigPreset(), pendingIntent).addOnCompleteListener((OnCompleteListener)new zzz(castRemoteDisplayLocalService));
        if (this.zzf.get() != null) {
            ((Callbacks)this.zzf.get()).onServiceCreated(this);
        }
        return true;
    }

    private final void zze() {
        if (this.zzf.get() != null) {
            ((Callbacks)this.zzf.get()).onRemoteDisplaySessionError(new Status(2200));
        }
        CastRemoteDisplayLocalService.stopService();
    }

    private final Notification zzd(boolean bl) {
        int n;
        int n2;
        this.zza("createDefaultNotification");
        String string2 = this.zzh.zzc;
        String string3 = this.zzh.zzd;
        if (bl) {
            n2 = R.string.cast_notification_connected_message;
            n = R.drawable.cast_ic_notification_on;
        } else {
            n2 = R.string.cast_notification_connecting_message;
            n = R.drawable.cast_ic_notification_connecting;
        }
        String string4 = TextUtils.isEmpty((CharSequence)string2) ? (String)this.getPackageManager().getApplicationLabel(this.getApplicationInfo()) : string2;
        String string5 = TextUtils.isEmpty((CharSequence)string3) ? this.getString(n2, new Object[]{this.zzl.getFriendlyName()}) : string3;
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, "cast_remote_display_local_service").setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(this.zzh.zzb).setSmallIcon(n).setOngoing(true);
        String string6 = this.getString(R.string.cast_notification_disconnect);
        CastRemoteDisplayLocalService castRemoteDisplayLocalService = this;
        if (castRemoteDisplayLocalService.zzk == null) {
            Intent intent = new Intent("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT");
            intent.setPackage(castRemoteDisplayLocalService.zzn.getPackageName());
            castRemoteDisplayLocalService.zzk = PendingIntent.getBroadcast((Context)castRemoteDisplayLocalService, (int)0, (Intent)intent, (int)0x8000000);
        }
        return builder.addAction(17301560, (CharSequence)string6, castRemoteDisplayLocalService.zzk).build();
    }

    private final void zza(String string2) {
        zza.zza("[Instance: %s] %s", new Object[]{this, string2});
    }

    private final void zzb(String string2) {
        zza.zzd("[Instance: %s] %s", new Object[]{this, string2});
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zza(string2);
    }

    static /* synthetic */ CastDevice zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzl;
    }

    static /* synthetic */ boolean zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzr;
    }

    static /* synthetic */ void zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2) {
        castRemoteDisplayLocalService.zzb(string2);
    }

    static /* synthetic */ boolean zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, String string2, CastDevice castDevice, Options options, NotificationSettings notificationSettings, Context context, ServiceConnection serviceConnection, Callbacks callbacks) {
        return castRemoteDisplayLocalService.zza(string2, castDevice, options, notificationSettings, context, serviceConnection, callbacks);
    }

    static /* synthetic */ zzbei zza() {
        return zza;
    }

    static /* synthetic */ AtomicBoolean zzb() {
        return zzd;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, boolean bl) {
        castRemoteDisplayLocalService.zzb(bl);
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, NotificationSettings notificationSettings) {
        castRemoteDisplayLocalService.zza(notificationSettings);
    }

    static /* synthetic */ void zzc(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        castRemoteDisplayLocalService.zze();
    }

    static /* synthetic */ Object zzc() {
        return zzc;
    }

    static /* synthetic */ CastRemoteDisplayLocalService zzd() {
        return zzu;
    }

    static /* synthetic */ void zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zza(display);
    }

    static /* synthetic */ Context zzd(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzn;
    }

    static /* synthetic */ ServiceConnection zze(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzo;
    }

    static /* synthetic */ ServiceConnection zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, ServiceConnection serviceConnection) {
        castRemoteDisplayLocalService.zzo = null;
        return null;
    }

    static /* synthetic */ Context zza(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Context context) {
        castRemoteDisplayLocalService.zzn = null;
        return null;
    }

    static /* synthetic */ WeakReference zzf(CastRemoteDisplayLocalService castRemoteDisplayLocalService) {
        return castRemoteDisplayLocalService.zzf;
    }

    static /* synthetic */ Display zzb(CastRemoteDisplayLocalService castRemoteDisplayLocalService, Display display) {
        castRemoteDisplayLocalService.zzm = null;
        return null;
    }

    @VisibleForTesting
    final class zza
    extends Binder {
        zza() {
        }
    }

    static final class zzb
    extends BroadcastReceiver {
        private zzb() {
        }

        public final void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_NOTIFICATION_DISCONNECT")) {
                CastRemoteDisplayLocalService.stopService();
                return;
            }
            if (intent.getAction().equals("com.google.android.gms.cast.remote_display.ACTION_SESSION_ENDED")) {
                CastRemoteDisplayLocalService.zzc(false);
            }
        }

        /* synthetic */ zzb(zzu zzu2) {
            this();
        }
    }

    public static class Options {
        @CastRemoteDisplay.Configuration
        private int zza = 2;

        public Options() {
        }

        public void setConfigPreset(@CastRemoteDisplay.Configuration int n) {
            this.zza = n;
        }

        @CastRemoteDisplay.Configuration
        public int getConfigPreset() {
            return this.zza;
        }
    }

    public static final class NotificationSettings {
        private Notification zza;
        private PendingIntent zzb;
        private String zzc;
        private String zzd;

        private NotificationSettings() {
        }

        private NotificationSettings(NotificationSettings notificationSettings) {
            this.zza = notificationSettings.zza;
            this.zzb = notificationSettings.zzb;
            this.zzc = notificationSettings.zzc;
            this.zzd = notificationSettings.zzd;
        }

        /* synthetic */ NotificationSettings(zzu zzu2) {
            this();
        }

        /* synthetic */ NotificationSettings(NotificationSettings notificationSettings, zzu zzu2) {
            this(notificationSettings);
        }

        public static final class Builder {
            private NotificationSettings zza = new NotificationSettings(null);

            public Builder() {
            }

            public final Builder setNotification(Notification notification) {
                this.zza.zza = notification;
                return this;
            }

            public final Builder setNotificationPendingIntent(PendingIntent pendingIntent) {
                this.zza.zzb = pendingIntent;
                return this;
            }

            public final Builder setNotificationTitle(String string2) {
                this.zza.zzc = string2;
                return this;
            }

            public final Builder setNotificationText(String string2) {
                this.zza.zzd = string2;
                return this;
            }

            public final NotificationSettings build() {
                if (this.zza.zza != null) {
                    if (!TextUtils.isEmpty((CharSequence)this.zza.zzc)) {
                        throw new IllegalArgumentException("notificationTitle requires using the default notification");
                    }
                    if (!TextUtils.isEmpty((CharSequence)this.zza.zzd)) {
                        throw new IllegalArgumentException("notificationText requires using the default notification");
                    }
                    if (this.zza.zzb != null) {
                        throw new IllegalArgumentException("notificationPendingIntent requires using the default notification");
                    }
                } else if (TextUtils.isEmpty((CharSequence)this.zza.zzc) && TextUtils.isEmpty((CharSequence)this.zza.zzd) && this.zza.zzb == null) {
                    throw new IllegalArgumentException("At least an argument must be provided");
                }
                return this.zza;
            }
        }
    }

    public static interface Callbacks {
        public void onServiceCreated(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionStarted(CastRemoteDisplayLocalService var1);

        public void onRemoteDisplaySessionError(Status var1);

        public void onRemoteDisplaySessionEnded(CastRemoteDisplayLocalService var1);
    }
}

