/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.zzak;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack
extends zzbgl
implements ReflectedParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    @Hide
    public static final Parcelable.Creator<MediaTrack> CREATOR = new zzak();
    private long zza;
    private int zzb;
    private String zzc;
    private String zzd;
    private String zze;
    private String zzf;
    private int zzg;
    private String zzh;
    private JSONObject zzi;

    MediaTrack(long l, int n, String string2, String string3, String string4, String string5, int n2, String string6) {
        this.zza = l;
        this.zzb = n;
        this.zzc = string2;
        this.zzd = string3;
        this.zze = string4;
        this.zzf = string5;
        this.zzg = n2;
        this.zzh = string6;
        if (this.zzh != null) {
            try {
                this.zzi = new JSONObject(this.zzh);
                return;
            }
            catch (JSONException jSONException) {
                this.zzi = null;
                this.zzh = null;
                return;
            }
        }
        this.zzi = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    MediaTrack(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2;
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this(0L, 0, null, null, null, null, -1, null);
                            jSONObject2 = jSONObject;
                            MediaTrack mediaTrack = this;
                            this.zza = jSONObject2.getLong("trackId");
                            string2 = jSONObject2.getString("type");
                            if ("TEXT".equals(string2)) {
                                mediaTrack.zzb = 1;
                            } else if ("AUDIO".equals(string2)) {
                                mediaTrack.zzb = 2;
                            } else if ("VIDEO".equals(string2)) {
                                mediaTrack.zzb = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            mediaTrack.zzc = jSONObject2.optString("trackContentId", null);
                            mediaTrack.zzd = jSONObject2.optString("trackContentType", null);
                            mediaTrack.zze = jSONObject2.optString("name", null);
                            mediaTrack.zzf = jSONObject2.optString("language", null);
                            if (!jSONObject2.has("subtype")) break block13;
                            string2 = jSONObject2.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            mediaTrack.zzg = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        mediaTrack.zzg = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    mediaTrack.zzg = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    mediaTrack.zzg = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    mediaTrack.zzg = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            mediaTrack.zzg = 0;
        }
        mediaTrack.zzi = jSONObject2.optJSONObject("customData");
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this(0L, 0, null, null, null, null, -1, null);
        this.zza = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzb = n;
    }

    public final long getId() {
        return this.zza;
    }

    public final int getType() {
        return this.zzb;
    }

    public final String getContentId() {
        return this.zzc;
    }

    public final void setContentId(String string2) {
        this.zzc = string2;
    }

    public final String getContentType() {
        return this.zzd;
    }

    public final void setContentType(String string2) {
        this.zzd = string2;
    }

    public final String getName() {
        return this.zze;
    }

    final void zza(String string2) {
        this.zze = string2;
    }

    public final String getLanguage() {
        return this.zzf;
    }

    final void zzb(String string2) {
        this.zzf = string2;
    }

    public final int getSubtype() {
        return this.zzg;
    }

    final void zza(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzb != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzg = n;
    }

    public final JSONObject getCustomData() {
        return this.zzi;
    }

    final void zza(JSONObject jSONObject) {
        this.zzi = jSONObject;
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zza);
            switch (this.zzb) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                }
            }
            if (this.zzc != null) {
                jSONObject.put("trackContentId", (Object)this.zzc);
            }
            if (this.zzd != null) {
                jSONObject.put("trackContentType", (Object)this.zzd);
            }
            if (this.zze != null) {
                jSONObject.put("name", (Object)this.zze);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzf)) {
                jSONObject.put("language", (Object)this.zzf);
            }
            switch (this.zzg) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                }
            }
            if (this.zzi != null) {
                jSONObject.put("customData", (Object)this.zzi);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)((Object)object);
        if (this.zzi == null != (mediaTrack.zzi == null)) {
            return false;
        }
        if (this.zzi != null && mediaTrack.zzi != null && !zzq.zza((Object)this.zzi, (Object)mediaTrack.zzi)) {
            return false;
        }
        return this.zza == mediaTrack.zza && this.zzb == mediaTrack.zzb && zzbdw.zza(this.zzc, mediaTrack.zzc) && zzbdw.zza(this.zzd, mediaTrack.zzd) && zzbdw.zza(this.zze, mediaTrack.zze) && zzbdw.zza(this.zzf, mediaTrack.zzf) && this.zzg == mediaTrack.zzg;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, String.valueOf(this.zzi)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzh = this.zzi == null ? null : this.zzi.toString();
        Parcel parcel2 = parcel;
        MediaTrack mediaTrack = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (long)mediaTrack.getId());
        zzbgo.zza((Parcel)parcel2, (int)3, (int)mediaTrack.getType());
        zzbgo.zza((Parcel)parcel2, (int)4, (String)mediaTrack.getContentId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)mediaTrack.getContentType(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)mediaTrack.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (String)mediaTrack.getLanguage(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (int)mediaTrack.getSubtype());
        zzbgo.zza((Parcel)parcel2, (int)9, (String)mediaTrack.zzh, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static class Builder {
        private final MediaTrack zza;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zza = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zza.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zza.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zza.zza(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zza.zzb(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zza.zzb(zzbdw.zza(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zza.zza(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zza.zza(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zza;
        }
    }
}

