/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.zzbn;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle
extends zzbgl {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    @Hide
    public static final Parcelable.Creator<TextTrackStyle> CREATOR = new zzbn();
    private float zza;
    private int zzb;
    private int zzc;
    private int zzd;
    private int zze;
    private int zzf;
    private int zzg;
    private int zzh;
    private String zzi;
    private int zzj;
    private int zzk;
    private String zzl;
    private JSONObject zzm;

    TextTrackStyle(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2, int n8, int n9, String string3) {
        this.zza = f;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = n3;
        this.zze = n4;
        this.zzf = n5;
        this.zzg = n6;
        this.zzh = n7;
        this.zzi = string2;
        this.zzj = n8;
        this.zzk = n9;
        this.zzl = string3;
        if (this.zzl != null) {
            try {
                this.zzm = new JSONObject(this.zzl);
                return;
            }
            catch (JSONException jSONException) {
                this.zzm = null;
                this.zzl = null;
                return;
            }
        }
        this.zzm = null;
    }

    public TextTrackStyle() {
        this(1.0f, 0, 0, -1, 0, -1, 0, 0, null, -1, -1, null);
    }

    public final void setFontScale(float f) {
        this.zza = f;
    }

    public final float getFontScale() {
        return this.zza;
    }

    public final void setForegroundColor(int n) {
        this.zzb = n;
    }

    public final int getForegroundColor() {
        return this.zzb;
    }

    public final void setBackgroundColor(int n) {
        this.zzc = n;
    }

    public final int getBackgroundColor() {
        return this.zzc;
    }

    public final void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzd = n;
    }

    public final int getEdgeType() {
        return this.zzd;
    }

    public final void setEdgeColor(int n) {
        this.zze = n;
    }

    public final int getEdgeColor() {
        return this.zze;
    }

    public final void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzf = n;
    }

    public final int getWindowType() {
        return this.zzf;
    }

    public final void setWindowColor(int n) {
        this.zzg = n;
    }

    public final int getWindowColor() {
        return this.zzg;
    }

    public final void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzh = n;
    }

    public final int getWindowCornerRadius() {
        return this.zzh;
    }

    public final void setFontFamily(String string2) {
        this.zzi = string2;
    }

    public final String getFontFamily() {
        return this.zzi;
    }

    public final void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzj = n;
    }

    public final int getFontGenericFamily() {
        return this.zzj;
    }

    public final void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzk = n;
    }

    public final int getFontStyle() {
        return this.zzk;
    }

    public final void setCustomData(JSONObject jSONObject) {
        this.zzm = jSONObject;
    }

    public final JSONObject getCustomData() {
        return this.zzm;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zze()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (!Typeface.SANS_SERIF.equals((Object)typeface) && Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    @Hide
    public final void zza(JSONObject jSONObject) throws JSONException {
        String string2;
        this.zza = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzb = TextTrackStyle.zza(jSONObject.optString("foregroundColor"));
        this.zzc = TextTrackStyle.zza(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzd = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzd = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzd = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzd = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzd = 4;
            }
        }
        this.zze = TextTrackStyle.zza(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzf = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzf = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzf = 2;
            }
        }
        this.zzg = TextTrackStyle.zza(jSONObject.optString("windowColor"));
        if (this.zzf == 2) {
            this.zzh = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzi = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzj = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzj = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzj = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzj = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzj = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzj = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzj = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzk = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzk = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzk = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzk = 3;
            }
        }
        this.zzm = jSONObject.optJSONObject("customData");
    }

    @Hide
    public final JSONObject zza() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zza);
            if (this.zzb != 0) {
                jSONObject.put("foregroundColor", (Object)TextTrackStyle.zza(this.zzb));
            }
            if (this.zzc != 0) {
                jSONObject.put("backgroundColor", (Object)TextTrackStyle.zza(this.zzc));
            }
            switch (this.zzd) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                }
            }
            if (this.zze != 0) {
                jSONObject.put("edgeColor", (Object)TextTrackStyle.zza(this.zze));
            }
            switch (this.zzf) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                }
            }
            if (this.zzg != 0) {
                jSONObject.put("windowColor", (Object)TextTrackStyle.zza(this.zzg));
            }
            if (this.zzf == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzh);
            }
            if (this.zzi != null) {
                jSONObject.put("fontFamily", (Object)this.zzi);
            }
            switch (this.zzj) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                }
            }
            switch (this.zzk) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                }
            }
            if (this.zzm != null) {
                jSONObject.put("customData", (Object)this.zzm);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject;
    }

    private static String zza(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private static int zza(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                return Color.argb((int)Integer.parseInt(string2.substring(7, 9), 16), (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)((Object)object);
        if (this.zzm == null != (textTrackStyle.zzm == null)) {
            return false;
        }
        if (this.zzm != null && textTrackStyle.zzm != null && !zzq.zza((Object)this.zzm, (Object)textTrackStyle.zzm)) {
            return false;
        }
        return this.zza == textTrackStyle.zza && this.zzb == textTrackStyle.zzb && this.zzc == textTrackStyle.zzc && this.zzd == textTrackStyle.zzd && this.zze == textTrackStyle.zze && this.zzf == textTrackStyle.zzf && this.zzh == textTrackStyle.zzh && zzbdw.zza(this.zzi, textTrackStyle.zzi) && this.zzj == textTrackStyle.zzj && this.zzk == textTrackStyle.zzk;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{Float.valueOf(this.zza), this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk, String.valueOf(this.zzm)});
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzl = this.zzm == null ? null : this.zzm.toString();
        Parcel parcel2 = parcel;
        TextTrackStyle textTrackStyle = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (float)textTrackStyle.getFontScale());
        zzbgo.zza((Parcel)parcel2, (int)3, (int)textTrackStyle.getForegroundColor());
        zzbgo.zza((Parcel)parcel2, (int)4, (int)textTrackStyle.getBackgroundColor());
        zzbgo.zza((Parcel)parcel2, (int)5, (int)textTrackStyle.getEdgeType());
        zzbgo.zza((Parcel)parcel2, (int)6, (int)textTrackStyle.getEdgeColor());
        zzbgo.zza((Parcel)parcel2, (int)7, (int)textTrackStyle.getWindowType());
        zzbgo.zza((Parcel)parcel2, (int)8, (int)textTrackStyle.getWindowColor());
        zzbgo.zza((Parcel)parcel2, (int)9, (int)textTrackStyle.getWindowCornerRadius());
        zzbgo.zza((Parcel)parcel2, (int)10, (String)textTrackStyle.getFontFamily(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)11, (int)textTrackStyle.getFontGenericFamily());
        zzbgo.zza((Parcel)parcel2, (int)12, (int)textTrackStyle.getFontStyle());
        zzbgo.zza((Parcel)parcel2, (int)13, (String)textTrackStyle.zzl, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }
}

