/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.cast.zzbo;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class VideoInfo
extends zzbgl {
    public static final int HDR_TYPE_UNKNOWN = 0;
    public static final int HDR_TYPE_SDR = 1;
    public static final int HDR_TYPE_HDR10 = 2;
    public static final int HDR_TYPE_DV = 3;
    public static final int HDR_TYPE_HDR = 4;
    @Hide
    public static final Parcelable.Creator<VideoInfo> CREATOR = new zzbo();
    private int zza;
    private int zzb;
    private int zzc;

    VideoInfo(int n, int n2, int n3) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
    }

    public final int getWidth() {
        return this.zza;
    }

    public final int getHeight() {
        return this.zzb;
    }

    public final int getHdrType() {
        return this.zzc;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        VideoInfo videoInfo = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (int)videoInfo.getWidth());
        zzbgo.zza((Parcel)parcel2, (int)3, (int)videoInfo.getHeight());
        zzbgo.zza((Parcel)parcel2, (int)4, (int)videoInfo.getHdrType());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VideoInfo)) {
            return false;
        }
        VideoInfo videoInfo = (VideoInfo)((Object)object);
        return this.zzb == videoInfo.getHeight() && this.zza == videoInfo.getWidth() && this.zzc == videoInfo.getHdrType();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzb, this.zza, this.zzc});
    }

    static VideoInfo zza(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        try {
            int n;
            String string2;
            switch (string2 = jSONObject.getString("hdrType")) {
                case "dv": {
                    n = 3;
                    break;
                }
                case "hdr10": {
                    n = 2;
                    break;
                }
                case "hdr": {
                    n = 4;
                    break;
                }
                case "sdr": {
                    n = 1;
                    break;
                }
                default: {
                    Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Unknown HDR type: %s", string2));
                    n = 0;
                }
            }
            return new VideoInfo(jSONObject.getInt("width"), jSONObject.getInt("height"), n);
        }
        catch (JSONException jSONException) {
            Log.d((String)"VideoInfo", (String)String.format(Locale.ROOT, "Error while creating a VideoInfo instance from JSON: %s", jSONException.getMessage()));
            return null;
        }
    }
}

