/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzab;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbdx;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzbei;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzbdp
extends com.google.android.gms.common.internal.zzab<zzbeb> {
    private static final zzbei zzd = new zzbei("CastClientImpl");
    private ApplicationMetadata zze;
    private final CastDevice zzf;
    private final Cast.Listener zzg;
    private final Map<String, Cast.MessageReceivedCallback> zzh;
    private final long zzi;
    private final Bundle zzj;
    private zzbdr zzk;
    private String zzl;
    private boolean zzm;
    private boolean zzn;
    private boolean zzo;
    private boolean zzp;
    private double zzq;
    private int zzr;
    private int zzs;
    private final AtomicLong zzt;
    private String zzu;
    private String zzv;
    private Bundle zzw;
    private final Map<Long, zzn<Status>> zzx;
    private zzn<Cast.ApplicationConnectionResult> zzy;
    private zzn<Status> zzz;
    private static final Object zzaa = new Object();
    private static final Object zzab = new Object();

    public zzbdp(Context context, Looper looper, zzr zzr2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzf = castDevice;
        this.zzg = listener;
        this.zzi = l;
        this.zzj = bundle;
        this.zzh = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzt = new AtomicLong(0L);
        this.zzx = new HashMap<Long, zzn<Status>>();
        this.zzaj();
    }

    private final void zzaj() {
        this.zzp = false;
        this.zzr = -1;
        this.zzs = -1;
        this.zze = null;
        this.zzl = null;
        this.zzq = 0.0;
        this.zzm = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzd.zza("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzp = true;
            this.zzn = true;
            this.zzo = true;
        } else {
            this.zzp = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzw = new Bundle();
            this.zzw.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void zzg() {
        zzd.zza("disconnect(); ServiceListener=%s, isConnected=%b", this.zzk, this.zzs());
        zzbdr zzbdr2 = this.zzk;
        this.zzk = null;
        if (zzbdr2 == null || zzbdr2.zza() == null) {
            zzd.zza("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzak();
        try {
            ((zzbeb)super.zzaf()).zza();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzd.zza(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.zzg();
        }
    }

    public final Bundle q_() {
        if (this.zzw != null) {
            Bundle bundle = this.zzw;
            this.zzw = null;
            return bundle;
        }
        return super.q_();
    }

    @NonNull
    protected final String zza() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzb() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzc() {
        Bundle bundle = new Bundle();
        zzd.zza("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzu, this.zzv);
        this.zzf.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzi);
        if (this.zzj != null) {
            bundle.putAll(this.zzj);
        }
        this.zzk = new zzbdr(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzk.asBinder()));
        if (this.zzu != null) {
            bundle.putString("last_application_id", this.zzu);
            if (this.zzv != null) {
                bundle.putString("last_session_id", this.zzv);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzn<Status> zzn2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzbdw.zza(string2);
        this.zzal();
        long l = this.zzt.incrementAndGet();
        try {
            this.zzx.put(l, zzn2);
            ((zzbeb)super.zzaf()).zza(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzx.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zzb(zzn2);
        ((zzbeb)super.zzaf()).zza(string2, launchOptions);
    }

    public final void zza(String string2, String string3, zzab zzab2, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zzb(zzn2);
        if (zzab2 == null) {
            zzab2 = new zzab();
        }
        ((zzbeb)super.zzaf()).zza(string2, string3, zzab2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzb(zzn<Cast.ApplicationConnectionResult> zzn2) {
        Object object = zzaa;
        synchronized (object) {
            if (this.zzy != null) {
                this.zzy.zza((Object)new zzbdq(new Status(2002)));
            }
            this.zzy = zzn2;
            return;
        }
    }

    public final void zza(zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbeb)super.zzaf()).zzb();
    }

    public final void zza(String string2, zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbeb)super.zzaf()).zza(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzn<Status> zzn2) {
        Object object = zzab;
        synchronized (object) {
            if (this.zzz != null) {
                zzn2.zza((Object)new Status(2001));
                return;
            }
            this.zzz = zzn2;
            return;
        }
    }

    public final void zzi() throws IllegalStateException, RemoteException {
        ((zzbeb)super.zzaf()).zzc();
    }

    public final void zza(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzbeb)super.zzaf()).zza(d, this.zzq, this.zzm);
    }

    public final void zza(boolean bl) throws IllegalStateException, RemoteException {
        ((zzbeb)super.zzaf()).zza(bl, this.zzq, this.zzm);
    }

    public final double zzj() throws IllegalStateException {
        this.zzal();
        return this.zzq;
    }

    public final boolean zzk() throws IllegalStateException {
        this.zzal();
        return this.zzm;
    }

    public final int zzl() throws IllegalStateException {
        this.zzal();
        return this.zzr;
    }

    public final int zzm() throws IllegalStateException {
        this.zzal();
        return this.zzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzbdw.zza(string2);
        this.zza(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzh;
            synchronized (map) {
                this.zzh.put(string2, messageReceivedCallback);
            }
            ((zzbeb)super.zzaf()).zzb(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzh;
        synchronized (map) {
            messageReceivedCallback = this.zzh.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzbeb)super.zzaf()).zzc(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzd.zza(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata zzn() throws IllegalStateException {
        this.zzal();
        return this.zze;
    }

    public final String zzo() throws IllegalStateException {
        this.zzal();
        return this.zzl;
    }

    public final void zza(ConnectionResult connectionResult) {
        super.zza(connectionResult);
        this.zzak();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzak() {
        zzd.zza("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzh;
        synchronized (map) {
            this.zzh.clear();
            return;
        }
    }

    private final void zza(zzbdx zzbdx2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzbdx2.zze();
        if (!zzbdw.zza(applicationMetadata, this.zze)) {
            this.zze = applicationMetadata;
            this.zzg.onApplicationMetadataChanged(this.zze);
        }
        boolean bl2 = false;
        double d = zzbdx2.zza();
        if (!Double.isNaN(d) && Math.abs(d - this.zzq) > 1.0E-7) {
            this.zzq = d;
            bl2 = true;
        }
        if ((bl = zzbdx2.zzb()) != this.zzm) {
            this.zzm = bl;
            bl2 = true;
        }
        zzd.zza("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzo);
        if (this.zzg != null && (bl2 || this.zzo)) {
            this.zzg.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzbdx2.zzc();
        if (n != this.zzr) {
            this.zzr = n;
            bl3 = true;
        }
        zzd.zza("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzo);
        if (this.zzg != null && (bl3 || this.zzo)) {
            this.zzg.onActiveInputStateChanged(this.zzr);
        }
        boolean bl4 = false;
        int n2 = zzbdx2.zzd();
        if (n2 != this.zzs) {
            this.zzs = n2;
            bl4 = true;
        }
        zzd.zza("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzo);
        if (this.zzg != null && (bl4 || this.zzo)) {
            this.zzg.onStandbyStateChanged(this.zzs);
        }
        this.zzo = false;
    }

    private final void zza(zzbdd zzbdd2) {
        boolean bl = false;
        String string2 = zzbdd2.zza();
        if (!zzbdw.zza(string2, this.zzl)) {
            this.zzl = string2;
            bl = true;
        }
        zzd.zza("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzn);
        if (this.zzg != null && (bl || this.zzn)) {
            this.zzg.onApplicationStatusChanged();
        }
        this.zzn = false;
    }

    private final void zzal() throws IllegalStateException {
        if (!this.zzp || this.zzk == null || this.zzk.zzb()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zza(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzbeb) {
            return (zzbeb)iInterface;
        }
        return new zzbec(iBinder2);
    }

    static /* synthetic */ void zza(zzbdp zzbdp2) {
        zzbdp2.zzaj();
    }

    static /* synthetic */ zzbei zzp() {
        return zzd;
    }

    static /* synthetic */ ApplicationMetadata zza(zzbdp zzbdp2, ApplicationMetadata applicationMetadata) {
        zzbdp2.zze = applicationMetadata;
        return zzbdp2.zze;
    }

    static /* synthetic */ String zza(zzbdp zzbdp2, String string2) {
        zzbdp2.zzu = string2;
        return zzbdp2.zzu;
    }

    static /* synthetic */ String zzb(zzbdp zzbdp2, String string2) {
        zzbdp2.zzv = string2;
        return zzbdp2.zzv;
    }

    static /* synthetic */ String zzc(zzbdp zzbdp2, String string2) {
        zzbdp2.zzl = string2;
        return zzbdp2.zzl;
    }

    static /* synthetic */ Object zzq() {
        return zzaa;
    }

    static /* synthetic */ zzn zzb(zzbdp zzbdp2) {
        return zzbdp2.zzy;
    }

    static /* synthetic */ zzn zza(zzbdp zzbdp2, zzn zzn2) {
        zzbdp2.zzy = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zzc(zzbdp zzbdp2) {
        return zzbdp2.zzg;
    }

    static /* synthetic */ void zza(zzbdp zzbdp2, zzbdx zzbdx2) {
        zzbdp2.zza(zzbdx2);
    }

    static /* synthetic */ void zza(zzbdp zzbdp2, zzbdd zzbdd2) {
        zzbdp2.zza(zzbdd2);
    }

    static /* synthetic */ Map zzd(zzbdp zzbdp2) {
        return zzbdp2.zzh;
    }

    static /* synthetic */ CastDevice zze(zzbdp zzbdp2) {
        return zzbdp2.zzf;
    }

    static /* synthetic */ Map zzf(zzbdp zzbdp2) {
        return zzbdp2.zzx;
    }

    static /* synthetic */ Object zzr() {
        return zzab;
    }

    static /* synthetic */ zzn zzg(zzbdp zzbdp2) {
        return zzbdp2.zzz;
    }

    static /* synthetic */ zzn zzb(zzbdp zzbdp2, zzn zzn2) {
        zzbdp2.zzz = null;
        return null;
    }
}

