/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzbdg;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzben;
import com.google.android.gms.internal.zzbeo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbej
extends zzbdg {
    public static final String zzd = zzbdw.zzb("com.google.cast.media");
    private long zze;
    private MediaStatus zzf;
    private final List<zzbeo> zzg;
    private zzbek zzh;
    private final zzbeo zzi;
    private final zzbeo zzj;
    private final zzbeo zzk;
    private final zzbeo zzl;
    private final zzbeo zzm;
    private final zzbeo zzn;
    private final zzbeo zzo;
    private final zzbeo zzp;
    private final zzbeo zzq;
    private final zzbeo zzr;
    private final zzbeo zzs;
    private final zzbeo zzt;
    private final zzbeo zzu;
    private final zzbeo zzv;
    private final zzbeo zzw;

    public zzbej(String string2, zze zze2) {
        super(zzd, zze2, "MediaControlChannel", null, 1000L);
        this.zzi = new zzbeo(this.zza, 86400000L);
        this.zzj = new zzbeo(this.zza, 86400000L);
        this.zzk = new zzbeo(this.zza, 86400000L);
        this.zzl = new zzbeo(this.zza, 86400000L);
        this.zzm = new zzbeo(this.zza, 86400000L);
        this.zzn = new zzbeo(this.zza, 86400000L);
        this.zzo = new zzbeo(this.zza, 86400000L);
        this.zzp = new zzbeo(this.zza, 86400000L);
        this.zzq = new zzbeo(this.zza, 86400000L);
        this.zzr = new zzbeo(this.zza, 86400000L);
        this.zzs = new zzbeo(this.zza, 86400000L);
        this.zzt = new zzbeo(this.zza, 86400000L);
        this.zzu = new zzbeo(this.zza, 86400000L);
        this.zzv = new zzbeo(this.zza, 86400000L);
        this.zzw = new zzbeo(this.zza, 86400000L);
        this.zzg = new ArrayList<zzbeo>();
        this.zzg.add(this.zzi);
        this.zzg.add(this.zzj);
        this.zzg.add(this.zzk);
        this.zzg.add(this.zzl);
        this.zzg.add(this.zzm);
        this.zzg.add(this.zzn);
        this.zzg.add(this.zzo);
        this.zzg.add(this.zzp);
        this.zzg.add(this.zzq);
        this.zzg.add(this.zzr);
        this.zzg.add(this.zzs);
        this.zzg.add(this.zzt);
        this.zzg.add(this.zzu);
        this.zzg.add(this.zzv);
        this.zzg.add(this.zzw);
        this.zzm();
    }

    public final void zza(zzbek zzbek2) {
        this.zzh = zzbek2;
    }

    public final long zza(@NonNull zzben zzben2, @NonNull MediaInfo mediaInfo, @NonNull MediaLoadOptions mediaLoadOptions) throws IllegalStateException, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzh();
        this.zzi.zza(l, zzben2);
        this.zza(true);
        try {
            JSONArray jSONArray;
            long[] lArray;
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"LOAD");
            jSONObject.put("media", (Object)mediaInfo.zza());
            jSONObject.put("autoplay", mediaLoadOptions.getAutoplay());
            jSONObject.put("currentTime", (double)mediaLoadOptions.getPlayPosition() / 1000.0);
            jSONObject.put("playbackRate", mediaLoadOptions.getPlaybackRate());
            if (mediaLoadOptions.getCredentials() != null) {
                jSONObject.put("credentials", (Object)mediaLoadOptions.getCredentials());
            }
            if (mediaLoadOptions.getCredentialsType() != null) {
                jSONObject.put("credentialsType", (Object)mediaLoadOptions.getCredentialsType());
            }
            if ((lArray = mediaLoadOptions.getActiveTrackIds()) != null) {
                jSONArray = new JSONArray();
                for (int i = 0; i < lArray.length; ++i) {
                    jSONArray.put(i, lArray[i]);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if ((jSONArray = mediaLoadOptions.getCustomData()) != null) {
                jSONObject.put("customData", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzj.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.zze());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzl.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.zze());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzc(zzben zzben2, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzk.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.zze());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, long l, int n, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzh();
        this.zzm.zza(l2, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.zze());
            jSONObject2.put("currentTime", (double)l / 1000.0);
            if (n == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, double d, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzn.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zze());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, boolean bl, JSONObject jSONObject) throws IllegalStateException, zzbel {
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzo.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.zze());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zzb(zzben zzben2, double d, JSONObject jSONObject) throws IllegalStateException, zzbel {
        if (this.zzf == null) {
            throw new zzbel();
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzw.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"SET_PLAYBACK_RATE");
            jSONObject2.put("playbackRate", d);
            jSONObject2.put("mediaSessionId", this.zzf.zza());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2) throws IllegalStateException {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzh();
        this.zzp.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zzf != null) {
                jSONObject.put("mediaSessionId", this.zzf.zza());
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, long[] lArray) throws IllegalStateException, zzbel {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzh();
        this.zzq.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.zze());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < lArray.length; ++i) {
                jSONArray.put(i, lArray[i]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, TextTrackStyle textTrackStyle) throws IllegalStateException, zzbel {
        JSONObject jSONObject = new JSONObject();
        long l = this.zzh();
        this.zzr.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.zza());
            }
            jSONObject.put("mediaSessionId", this.zze());
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject.toString(), l, null);
        return l;
    }

    public final long zza() {
        MediaInfo mediaInfo = this.zzd();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zze == 0L) {
            return 0L;
        }
        double d = this.zzf.getPlaybackRate();
        long l = this.zzf.getStreamPosition();
        int n = this.zzf.getPlayerState();
        if (d == 0.0 || n != 2) {
            return l;
        }
        long l2 = mediaInfo.getStreamDuration();
        zzbej zzbej2 = this;
        long l3 = zzbej2.zza.zzb() - zzbej2.zze;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l;
        }
        long l4 = l + (long)((double)l3 * d);
        if (l2 > 0L && l4 > l2) {
            l4 = l2;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public final long zzb() {
        MediaInfo mediaInfo = this.zzd();
        if (mediaInfo != null) {
            return mediaInfo.getStreamDuration();
        }
        return 0L;
    }

    public final MediaStatus zzc() {
        return this.zzf;
    }

    public final MediaInfo zzd() {
        if (this.zzf == null) {
            return null;
        }
        return this.zzf.getMediaInfo();
    }

    public final long zza(zzben zzben2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalStateException, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("items must not be null or empty.");
        }
        if (n < 0 || n >= mediaQueueItemArray.length) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid startIndex: ").append(n).toString());
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzh();
        this.zzi.zza(l2, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_LOAD");
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].zzb());
            }
            jSONObject2.put("items", (Object)jSONArray);
            switch (n2) {
                case 0: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                    break;
                }
                case 1: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                    break;
                }
                case 2: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                    break;
                }
                case 3: {
                    jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(32).append("Invalid repeat mode: ").append(n2).toString());
                }
            }
            jSONObject2.put("startIndex", n);
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, MediaQueueItem[] mediaQueueItemArray, int n, int n2, int n3, long l, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (mediaQueueItemArray == null || mediaQueueItemArray.length == 0) {
            throw new IllegalArgumentException("itemsToInsert must not be null or empty.");
        }
        if (n3 != -1 && (n3 < 0 || n3 >= mediaQueueItemArray.length)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "currentItemIndexInItemsToInsert %d out of range [0, %d).", n3, mediaQueueItemArray.length));
        }
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(54).append("playPosition can not be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzh();
        this.zzs.zza(l2, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_INSERT");
            jSONObject2.put("mediaSessionId", this.zze());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                jSONArray.put(i, (Object)mediaQueueItemArray[i].zzb());
            }
            jSONObject2.put("items", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (n3 != -1) {
                jSONObject2.put("currentItemIndex", n3);
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, int n, long l, MediaQueueItem[] mediaQueueItemArray, int n2, Integer n3, JSONObject jSONObject) throws IllegalArgumentException, IllegalStateException, zzbel {
        if (l != -1L && l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("playPosition cannot be negative: ").append(l).toString());
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.zzh();
        this.zzt.zza(l2, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"QUEUE_UPDATE");
            jSONObject2.put("mediaSessionId", this.zze());
            if (n != 0) {
                jSONObject2.put("currentItemId", n);
            }
            if (n2 != 0) {
                jSONObject2.put("jump", n2);
            }
            if (mediaQueueItemArray != null && mediaQueueItemArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                    jSONArray.put(i, (Object)mediaQueueItemArray[i].zzb());
                }
                jSONObject2.put("items", (Object)jSONArray);
            }
            if (n3 != null) {
                switch (n3) {
                    case 0: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_OFF");
                        break;
                    }
                    case 1: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL");
                        break;
                    }
                    case 2: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_SINGLE");
                        break;
                    }
                    case 3: {
                        jSONObject2.put("repeatMode", (Object)"REPEAT_ALL_AND_SHUFFLE");
                    }
                }
            }
            if (l != -1L) {
                jSONObject2.put("currentTime", (double)l / 1000.0);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l2, null);
        return l2;
    }

    public final long zza(zzben zzben2, int[] nArray, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToRemove must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzu.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REMOVE");
            jSONObject2.put("mediaSessionId", this.zze());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(zzben zzben2, int[] nArray, int n, JSONObject jSONObject) throws IllegalStateException, zzbel, IllegalArgumentException {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("itemIdsToReorder must not be null or empty.");
        }
        JSONObject jSONObject2 = new JSONObject();
        long l = this.zzh();
        this.zzv.zza(l, zzben2);
        this.zza(true);
        try {
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", (Object)"QUEUE_REORDER");
            jSONObject2.put("mediaSessionId", this.zze());
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < nArray.length; ++i) {
                jSONArray.put(i, nArray[i]);
            }
            jSONObject2.put("itemIds", (Object)jSONArray);
            if (n != 0) {
                jSONObject2.put("insertBefore", n);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {}
        this.zza(jSONObject2.toString(), l, null);
        return l;
    }

    public final long zza(String string2, List<zzbl> list) throws IllegalStateException {
        long l = this.zzh();
        this.zza(zzbej.zza(string2, list, l), l, null);
        return l;
    }

    private static String zza(String string2, List<zzbl> list, long l) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("requestId", l);
            jSONObject.put("type", (Object)"PRECACHE");
            if (string2 != null) {
                jSONObject.put("precacheData", (Object)string2);
            }
            if (list != null && !list.isEmpty()) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < list.size(); ++i) {
                    jSONArray.put(i, (Object)list.get(i).zza());
                }
                jSONObject.put("requestItems", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {}
        return jSONObject.toString();
    }

    @Override
    public final void zza(String string2) {
        this.zzc.zza("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l = jSONObject.optLong("requestId", -1L);
            switch (string3) {
                case "MEDIA_STATUS": {
                    JSONArray jSONArray = jSONObject.getJSONArray("status");
                    if (jSONArray.length() > 0) {
                        this.zza(l, jSONArray.getJSONObject(0));
                        return;
                    }
                    this.zzf = null;
                    this.zzi();
                    this.zzj();
                    this.zzk();
                    this.zzl();
                    this.zzp.zza(l, 0, null);
                    return;
                }
                case "INVALID_PLAYER_STATE": {
                    this.zzc.zzc("received unexpected error: Invalid Player State.", new Object[0]);
                    JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                    Iterator<zzbeo> iterator = this.zzg.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zza(l, 2100, jSONObject2);
                    }
                    return;
                }
                case "LOAD_FAILED": {
                    JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                    this.zzi.zza(l, 2100, jSONObject3);
                    return;
                }
                case "LOAD_CANCELLED": {
                    JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                    this.zzi.zza(l, 2101, jSONObject4);
                    return;
                }
                case "INVALID_REQUEST": {
                    this.zzc.zzc("received unexpected error: Invalid Request.", new Object[0]);
                    JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                    Iterator<zzbeo> iterator = this.zzg.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().zza(l, 2100, jSONObject5);
                    }
                    break;
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            this.zzc.zzc("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
    }

    private final void zza(long l, JSONObject jSONObject) throws JSONException {
        int n;
        boolean bl = this.zzi.zza(l);
        boolean bl2 = this.zzm.zzb() && !this.zzm.zza(l);
        boolean bl3 = this.zzn.zzb() && !this.zzn.zza(l) || this.zzo.zzb() && !this.zzo.zza(l);
        int n2 = 0;
        if (bl2) {
            n2 = 2;
        }
        if (bl3) {
            n2 |= 1;
        }
        if (bl || this.zzf == null) {
            this.zzf = new MediaStatus(jSONObject);
            this.zze = this.zza.zzb();
            n = 127;
        } else {
            n = this.zzf.zza(jSONObject, n2);
        }
        if ((n & 1) != 0) {
            this.zze = this.zza.zzb();
            this.zzi();
        }
        if ((n & 2) != 0) {
            this.zze = this.zza.zzb();
            this.zzi();
        }
        if ((n & 4) != 0) {
            this.zzj();
        }
        if ((n & 8) != 0) {
            this.zzk();
        }
        if ((n & 0x10) != 0) {
            this.zzl();
        }
        if ((n & 0x20) != 0) {
            this.zze = this.zza.zzb();
            zzbej zzbej2 = this;
            if (zzbej2.zzh != null) {
                zzbej2.zzh.zze();
            }
        }
        if ((n & 0x40) != 0) {
            this.zze = this.zza.zzb();
            this.zzi();
        }
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            long l2 = l;
            iterator.next().zza(l2, 0, null);
        }
    }

    private final long zze() throws zzbel {
        if (this.zzf == null) {
            throw new zzbel();
        }
        return this.zzf.zza();
    }

    private final void zzi() {
        if (this.zzh != null) {
            this.zzh.zza();
        }
    }

    private final void zzj() {
        if (this.zzh != null) {
            this.zzh.zzb();
        }
    }

    private final void zzk() {
        if (this.zzh != null) {
            this.zzh.zzc();
        }
    }

    private final void zzl() {
        if (this.zzh != null) {
            this.zzh.zzd();
        }
    }

    private final void zzm() {
        this.zze = 0L;
        this.zzf = null;
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza();
        }
    }

    @Override
    public final void zzf() {
        super.zzf();
        this.zzm();
    }

    @Override
    public final void zza(long l, int n) {
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            int n2 = n;
            long l2 = l;
            iterator.next().zza(l2, n2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(long l) {
        Iterator<zzbeo> iterator = this.zzg.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(l, 2102);
        }
        boolean bl = false;
        Object object = zzbeo.zza;
        synchronized (object) {
            Iterator<zzbeo> iterator2 = this.zzg.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().zzb()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }
}

