/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.zzaf;
import org.json.JSONObject;

public class MediaLoadOptions {
    public static final double PLAYBACK_RATE_MIN = 0.5;
    public static final double PLAYBACK_RATE_MAX = 2.0;
    private boolean zzewi;
    private long zzewj;
    private double zzewk;
    private long[] zzewl;
    private JSONObject zzess;
    private String zzewm;
    private String zzewn;

    private MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3) {
        this.zzewi = bl;
        this.zzewj = l;
        this.zzewk = d;
        this.zzewl = lArray;
        this.zzess = jSONObject;
        this.zzewm = string2;
        this.zzewn = string3;
    }

    public boolean getAutoplay() {
        return this.zzewi;
    }

    public long getPlayPosition() {
        return this.zzewj;
    }

    public double getPlaybackRate() {
        return this.zzewk;
    }

    public long[] getActiveTrackIds() {
        return this.zzewl;
    }

    public JSONObject getCustomData() {
        return this.zzess;
    }

    public String getCredentials() {
        return this.zzewm;
    }

    public String getCredentialsType() {
        return this.zzewn;
    }

    /* synthetic */ MediaLoadOptions(boolean bl, long l, double d, long[] lArray, JSONObject jSONObject, String string2, String string3, zzaf zzaf2) {
        this(bl, l, d, lArray, jSONObject, string2, string3);
    }

    public static class Builder {
        private boolean zzewi = true;
        private long zzewj = 0L;
        private double zzewk = 1.0;
        private long[] zzewl = null;
        private JSONObject zzess = null;
        private String zzewm = null;
        private String zzewn = null;

        public Builder() {
        }

        public Builder setAutoplay(boolean bl) {
            this.zzewi = bl;
            return this;
        }

        public Builder setPlayPosition(long l) {
            this.zzewj = l;
            return this;
        }

        public Builder setPlaybackRate(double d) {
            if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
                throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
            }
            this.zzewk = d;
            return this;
        }

        public Builder setActiveTrackIds(long[] lArray) {
            this.zzewl = lArray;
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzess = jSONObject;
            return this;
        }

        public Builder setCredentials(String string2) {
            this.zzewm = string2;
            return this;
        }

        public Builder setCredentialsType(String string2) {
            this.zzewn = string2;
            return this;
        }

        public MediaLoadOptions build() {
            return new MediaLoadOptions(this.zzewi, this.zzewj, this.zzewk, this.zzewl, this.zzess, this.zzewm, this.zzewn, null);
        }
    }
}

