/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.zzab;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzbdd;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzbdr;
import com.google.android.gms.internal.zzbdw;
import com.google.android.gms.internal.zzbdx;
import com.google.android.gms.internal.zzbeb;
import com.google.android.gms.internal.zzbec;
import com.google.android.gms.internal.zzbei;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class zzbdp
extends com.google.android.gms.common.internal.zzab<zzbeb> {
    private static final zzbei zzeus = new zzbei("CastClientImpl");
    private ApplicationMetadata zzfmc;
    private final CastDevice zzfar;
    private final Cast.Listener zzetn;
    private final Map<String, Cast.MessageReceivedCallback> zzfmd;
    private final long zzfme;
    private final Bundle mExtras;
    private zzbdr zzfmf;
    private String zzfmg;
    private boolean zzexi;
    private boolean zzfmh;
    private boolean zzfmi;
    private boolean zzfmj;
    private double zzexh;
    private int zzfmk;
    private int zzfml;
    private final AtomicLong zzfmm;
    private String zzfmn;
    private String zzfmo;
    private Bundle zzfmp;
    private final Map<Long, zzn<Status>> zzfmq;
    private zzn<Cast.ApplicationConnectionResult> zzfmr;
    private zzn<Status> zzfms;
    private static final Object zzfmt = new Object();
    private static final Object zzfmu = new Object();

    public zzbdp(Context context, Looper looper, zzr zzr2, CastDevice castDevice, long l, Cast.Listener listener, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzr2, connectionCallbacks, onConnectionFailedListener);
        this.zzfar = castDevice;
        this.zzetn = listener;
        this.zzfme = l;
        this.mExtras = bundle;
        this.zzfmd = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzfmm = new AtomicLong(0L);
        this.zzfmq = new HashMap<Long, zzn<Status>>();
        this.zzago();
    }

    private final void zzago() {
        this.zzfmj = false;
        this.zzfmk = -1;
        this.zzfml = -1;
        this.zzfmc = null;
        this.zzfmg = null;
        this.zzexh = 0.0;
        this.zzexi = false;
    }

    protected final void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzeus.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzfmj = true;
            this.zzfmh = true;
            this.zzfmi = true;
        } else {
            this.zzfmj = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzfmp = new Bundle();
            this.zzfmp.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    public final void disconnect() {
        zzeus.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzfmf, this.isConnected());
        zzbdr zzbdr2 = this.zzfmf;
        this.zzfmf = null;
        if (zzbdr2 == null || zzbdr2.zzagv() == null) {
            zzeus.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzagq();
        try {
            ((zzbeb)super.zzalw()).disconnect();
            return;
        }
        catch (RemoteException | IllegalStateException throwable) {
            zzeus.zzb(throwable, "Error while disconnecting the controller interface: %s", throwable.getMessage());
            return;
        }
        finally {
            super.disconnect();
        }
    }

    public final Bundle zzagp() {
        if (this.zzfmp != null) {
            Bundle bundle = this.zzfmp;
            this.zzfmp = null;
            return bundle;
        }
        return super.zzagp();
    }

    @NonNull
    protected final String zzhm() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @NonNull
    protected final String zzhn() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected final Bundle zzabt() {
        Bundle bundle = new Bundle();
        zzeus.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzfmn, this.zzfmo);
        this.zzfar.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzfme);
        if (this.mExtras != null) {
            bundle.putAll(this.mExtras);
        }
        this.zzfmf = new zzbdr(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzfmf.asBinder()));
        if (this.zzfmn != null) {
            bundle.putString("last_application_id", this.zzfmn);
            if (this.zzfmo != null) {
                bundle.putString("last_session_id", this.zzfmo);
            }
        }
        return bundle;
    }

    public final void zza(String string2, String string3, zzn<Status> zzn2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzbdw.zzfv(string2);
        this.zzagr();
        long l = this.zzfmm.incrementAndGet();
        try {
            this.zzfmq.put(l, zzn2);
            ((zzbeb)super.zzalw()).zzb(string2, string3, l);
            return;
        }
        catch (Throwable throwable) {
            this.zzfmq.remove(l);
            throw throwable;
        }
    }

    public final void zza(String string2, LaunchOptions launchOptions, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        ((zzbeb)super.zzalw()).zzb(string2, launchOptions);
    }

    public final void zza(String string2, String string3, zzab zzab2, zzn<Cast.ApplicationConnectionResult> zzn2) throws IllegalStateException, RemoteException {
        this.zza(zzn2);
        if (zzab2 == null) {
            zzab2 = new zzab();
        }
        ((zzbeb)super.zzalw()).zza(string2, string3, zzab2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzn<Cast.ApplicationConnectionResult> zzn2) {
        Object object = zzfmt;
        synchronized (object) {
            if (this.zzfmr != null) {
                this.zzfmr.setResult((Object)new zzbdq(new Status(2002)));
            }
            this.zzfmr = zzn2;
            return;
        }
    }

    public final void zzb(zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbeb)super.zzalw()).zzagx();
    }

    public final void zza(String string2, zzn<Status> zzn2) throws IllegalStateException, RemoteException {
        this.zzc(zzn2);
        ((zzbeb)super.zzalw()).zzfp(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzc(zzn<Status> zzn2) {
        Object object = zzfmu;
        synchronized (object) {
            if (this.zzfms != null) {
                zzn2.setResult((Object)new Status(2001));
                return;
            }
            this.zzfms = zzn2;
            return;
        }
    }

    public final void requestStatus() throws IllegalStateException, RemoteException {
        ((zzbeb)super.zzalw()).requestStatus();
    }

    public final void setVolume(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        ((zzbeb)super.zzalw()).zza(d, this.zzexh, this.zzexi);
    }

    public final void setMute(boolean bl) throws IllegalStateException, RemoteException {
        ((zzbeb)super.zzalw()).zza(bl, this.zzexh, this.zzexi);
    }

    public final double getVolume() throws IllegalStateException {
        this.zzagr();
        return this.zzexh;
    }

    public final boolean isMute() throws IllegalStateException {
        this.zzagr();
        return this.zzexi;
    }

    public final int getActiveInputState() throws IllegalStateException {
        this.zzagr();
        return this.zzfmk;
    }

    public final int getStandbyState() throws IllegalStateException {
        this.zzagr();
        return this.zzfml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzbdw.zzfv(string2);
        this.removeMessageReceivedCallbacks(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzfmd;
            synchronized (map) {
                this.zzfmd.put(string2, messageReceivedCallback);
            }
            ((zzbeb)super.zzalw()).zzfy(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageReceivedCallbacks(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzfmd;
        synchronized (map) {
            messageReceivedCallback = this.zzfmd.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzbeb)super.zzalw()).zzfz(string2);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                zzeus.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public final ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzagr();
        return this.zzfmc;
    }

    public final String getApplicationStatus() throws IllegalStateException {
        this.zzagr();
        return this.zzfmg;
    }

    public final void onConnectionFailed(ConnectionResult connectionResult) {
        super.onConnectionFailed(connectionResult);
        this.zzagq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzagq() {
        zzeus.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzfmd;
        synchronized (map) {
            this.zzfmd.clear();
            return;
        }
    }

    private final void zza(zzbdx zzbdx2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzbdx2.getApplicationMetadata();
        if (!zzbdw.zza(applicationMetadata, this.zzfmc)) {
            this.zzfmc = applicationMetadata;
            this.zzetn.onApplicationMetadataChanged(this.zzfmc);
        }
        boolean bl2 = false;
        double d = zzbdx2.getVolume();
        if (!Double.isNaN(d) && Math.abs(d - this.zzexh) > 1.0E-7) {
            this.zzexh = d;
            bl2 = true;
        }
        if ((bl = zzbdx2.zzagw()) != this.zzexi) {
            this.zzexi = bl;
            bl2 = true;
        }
        zzeus.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzfmi);
        if (this.zzetn != null && (bl2 || this.zzfmi)) {
            this.zzetn.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzbdx2.getActiveInputState();
        if (n != this.zzfmk) {
            this.zzfmk = n;
            bl3 = true;
        }
        zzeus.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzfmi);
        if (this.zzetn != null && (bl3 || this.zzfmi)) {
            this.zzetn.onActiveInputStateChanged(this.zzfmk);
        }
        boolean bl4 = false;
        int n2 = zzbdx2.getStandbyState();
        if (n2 != this.zzfml) {
            this.zzfml = n2;
            bl4 = true;
        }
        zzeus.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzfmi);
        if (this.zzetn != null && (bl4 || this.zzfmi)) {
            this.zzetn.onStandbyStateChanged(this.zzfml);
        }
        this.zzfmi = false;
    }

    private final void zza(zzbdd zzbdd2) {
        boolean bl = false;
        String string2 = zzbdd2.zzagl();
        if (!zzbdw.zza(string2, this.zzfmg)) {
            this.zzfmg = string2;
            bl = true;
        }
        zzeus.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzfmh);
        if (this.zzetn != null && (bl || this.zzfmh)) {
            this.zzetn.onApplicationStatusChanged();
        }
        this.zzfmh = false;
    }

    private final void zzagr() throws IllegalStateException {
        if (!this.zzfmj || this.zzfmf == null || this.zzfmf.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected final /* synthetic */ IInterface zzd(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.cast.internal.ICastDeviceController");
        if (iInterface instanceof zzbeb) {
            return (zzbeb)iInterface;
        }
        return new zzbec(iBinder2);
    }

    static /* synthetic */ void zzc(zzbdp zzbdp2) {
        zzbdp2.zzago();
    }

    static /* synthetic */ zzbei zzags() {
        return zzeus;
    }

    static /* synthetic */ ApplicationMetadata zza(zzbdp zzbdp2, ApplicationMetadata applicationMetadata) {
        zzbdp2.zzfmc = applicationMetadata;
        return zzbdp2.zzfmc;
    }

    static /* synthetic */ String zza(zzbdp zzbdp2, String string2) {
        zzbdp2.zzfmn = string2;
        return zzbdp2.zzfmn;
    }

    static /* synthetic */ String zzb(zzbdp zzbdp2, String string2) {
        zzbdp2.zzfmo = string2;
        return zzbdp2.zzfmo;
    }

    static /* synthetic */ String zzc(zzbdp zzbdp2, String string2) {
        zzbdp2.zzfmg = string2;
        return zzbdp2.zzfmg;
    }

    static /* synthetic */ Object zzagt() {
        return zzfmt;
    }

    static /* synthetic */ zzn zzd(zzbdp zzbdp2) {
        return zzbdp2.zzfmr;
    }

    static /* synthetic */ zzn zza(zzbdp zzbdp2, zzn zzn2) {
        zzbdp2.zzfmr = null;
        return null;
    }

    static /* synthetic */ Cast.Listener zze(zzbdp zzbdp2) {
        return zzbdp2.zzetn;
    }

    static /* synthetic */ void zza(zzbdp zzbdp2, zzbdx zzbdx2) {
        zzbdp2.zza(zzbdx2);
    }

    static /* synthetic */ void zza(zzbdp zzbdp2, zzbdd zzbdd2) {
        zzbdp2.zza(zzbdd2);
    }

    static /* synthetic */ Map zzf(zzbdp zzbdp2) {
        return zzbdp2.zzfmd;
    }

    static /* synthetic */ CastDevice zzg(zzbdp zzbdp2) {
        return zzbdp2.zzfar;
    }

    static /* synthetic */ Map zzh(zzbdp zzbdp2) {
        return zzbdp2.zzfmq;
    }

    static /* synthetic */ Object zzagu() {
        return zzfmu;
    }

    static /* synthetic */ zzn zzi(zzbdp zzbdp2) {
        return zzbdp2.zzfms;
    }

    static /* synthetic */ zzn zzb(zzbdp zzbdp2, zzn zzn2) {
        zzbdp2.zzfms = null;
        return null;
    }
}

