/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzjv;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int zzFG;
    String zzIm;
    String mName;
    List<WebImage> zzIn;
    List<String> zzIo;
    String zzIp;
    Uri zzIq;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.zzFG = versionCode;
        this.zzIm = applicationId;
        this.mName = name;
        this.zzIn = images;
        this.zzIo = namespaces;
        this.zzIp = senderAppIdentifier;
        this.zzIq = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.zzFG = 1;
        this.zzIn = new ArrayList<WebImage>();
        this.zzIo = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.zzFG;
    }

    public String getApplicationId() {
        return this.zzIm;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzIo != null && this.zzIo.contains(namespace);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzIo != null && this.zzIo.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzIp;
    }

    public Uri zzhh() {
        return this.zzIq;
    }

    public List<WebImage> getImages() {
        return this.zzIn;
    }

    public String toString() {
        return "applicationId: " + this.zzIm + ", name: " + this.mName + ", images.count: " + (this.zzIn == null ? 0 : this.zzIn.size()) + ", namespaces.count: " + (this.zzIo == null ? 0 : this.zzIo.size()) + ", senderAppIdentifier: " + this.zzIp + ", senderAppLaunchUrl: " + this.zzIq;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzFG, this.zzIm, this.mName, this.zzIn, this.zzIo, this.zzIp, this.zzIq});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzjv.zza(this.zzIm, applicationMetadata.zzIm) && zzjv.zza(this.zzIn, applicationMetadata.zzIn) && zzjv.zza(this.mName, applicationMetadata.mName) && zzjv.zza(this.zzIo, applicationMetadata.zzIo) && zzjv.zza(this.zzIp, applicationMetadata.zzIp) && zzjv.zza(this.zzIq, applicationMetadata.zzIq);
    }
}

