/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzma;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzIQ;
    private int zzIR;
    private String zzIS;
    private MediaMetadata zzIT;
    private long zzIU;
    private List<MediaTrack> zzIV;
    private TextTrackStyle zzIW;
    private JSONObject zzIX;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzIQ = contentId;
        this.zzIR = -1;
        this.zzIU = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzIQ = json.getString("contentId");
        String string = json.getString("streamType");
        this.zzIR = "NONE".equals(string) ? 0 : ("BUFFERED".equals(string) ? 1 : ("LIVE".equals(string) ? 2 : -1));
        this.zzIS = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzIT = new MediaMetadata(n);
            this.zzIT.zzd(jSONObject);
        }
        this.zzIU = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzIU = zzjv.zzb(d);
        }
        if (json.has("tracks")) {
            this.zzIV = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzIV.add(mediaTrack);
            }
        } else {
            this.zzIV = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzd(jSONObject);
            this.zzIW = textTrackStyle;
        } else {
            this.zzIW = null;
        }
        this.zzIX = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzIQ;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzIR = streamType;
    }

    public int getStreamType() {
        return this.zzIR;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzIS = contentType;
    }

    public String getContentType() {
        return this.zzIS;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzIT = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzIT;
    }

    void zzm(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzIU = l;
    }

    public long getStreamDuration() {
        return this.zzIU;
    }

    void zzg(List<MediaTrack> list) {
        this.zzIV = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzIV;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzIW = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzIW;
    }

    void setCustomData(JSONObject customData) {
        this.zzIX = customData;
    }

    public JSONObject getCustomData() {
        return this.zzIX;
    }

    void zzhi() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzIQ)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzIS)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzIR == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            jSONObject.put("contentId", (Object)this.zzIQ);
            switch (this.zzIR) {
                case 1: {
                    string = "BUFFERED";
                    break;
                }
                case 2: {
                    string = "LIVE";
                    break;
                }
                default: {
                    string = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string);
            if (this.zzIS != null) {
                jSONObject.put("contentType", (Object)this.zzIS);
            }
            if (this.zzIT != null) {
                jSONObject.put("metadata", (Object)this.zzIT.toJson());
            }
            if (this.zzIU <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzjv.zzp(this.zzIU));
            }
            if (this.zzIV != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzIV) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzIW != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzIW.toJson());
            }
            if (this.zzIX != null) {
                jSONObject.put("customData", (Object)this.zzIX);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzIX == null != (mediaInfo.zzIX == null)) {
            return false;
        }
        if (this.zzIX != null && mediaInfo.zzIX != null && !zzma.zzd((Object)this.zzIX, (Object)mediaInfo.zzIX)) {
            return false;
        }
        return zzjv.zza(this.zzIQ, mediaInfo.zzIQ) && this.zzIR == mediaInfo.zzIR && zzjv.zza(this.zzIS, mediaInfo.zzIS) && zzjv.zza(this.zzIT, mediaInfo.zzIT) && this.zzIU == mediaInfo.zzIU;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzIQ, this.zzIR, this.zzIS, this.zzIT, this.zzIU, String.valueOf(this.zzIX)});
    }

    public static class Builder {
        private final MediaInfo zzIY;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzIY = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzIY.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzIY.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzIY.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzIY.zzm(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzIY.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzIY.zzg(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzIY.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzIY.zzhi();
            return this.zzIY;
        }
    }
}

