/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.internal.zzjv;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    private long zzJg;
    private MediaInfo zzIY;
    private double zzJh;
    private int zzJi;
    private int zzJj;
    private long zzJk;
    private long zzJl;
    private double zzJm;
    private boolean zzJn;
    private long[] zzJo;
    private JSONObject zzIX;

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zzhj() {
        return this.zzJg;
    }

    public int getPlayerState() {
        return this.zzJi;
    }

    public int getIdleReason() {
        return this.zzJj;
    }

    public double getPlaybackRate() {
        return this.zzJh;
    }

    public MediaInfo getMediaInfo() {
        return this.zzIY;
    }

    public long getStreamPosition() {
        return this.zzJk;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzJl & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzJm;
    }

    public boolean isMute() {
        return this.zzJn;
    }

    public long[] getActiveTrackIds() {
        return this.zzJo;
    }

    public JSONObject getCustomData() {
        return this.zzIX;
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        long l;
        long l2;
        double d;
        int n3 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzJg) {
            this.zzJg = l3;
            n3 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n4 = 0;
            String string = jSONObject.getString("playerState");
            if (string.equals("IDLE")) {
                n4 = 1;
            } else if (string.equals("PLAYING")) {
                n4 = 2;
            } else if (string.equals("PAUSED")) {
                n4 = 3;
            } else if (string.equals("BUFFERING")) {
                n4 = 4;
            }
            if (n4 != this.zzJi) {
                this.zzJi = n4;
                n3 |= 2;
            }
            if (n4 == 1 && jSONObject.has("idleReason")) {
                int n5 = 0;
                string = jSONObject.getString("idleReason");
                if (string.equals("CANCELLED")) {
                    n5 = 2;
                } else if (string.equals("INTERRUPTED")) {
                    n5 = 3;
                } else if (string.equals("FINISHED")) {
                    n5 = 1;
                } else if (string.equals("ERROR")) {
                    n5 = 4;
                }
                if (n5 != this.zzJj) {
                    this.zzJj = n5;
                    n3 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzJh != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzJh = d;
            n3 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzjv.zzb(jSONObject.getDouble("currentTime"))) != this.zzJk) {
            this.zzJk = l2;
            n3 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzJl) {
            this.zzJl = l;
            n3 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzJm) {
                this.zzJm = d2;
                n3 |= 2;
            }
            if ((n2 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzJn) {
                this.zzJn = n2;
                n3 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n6;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n2 = jSONArray.length();
            lArray = new long[n2];
            for (n6 = 0; n6 < n2; ++n6) {
                lArray[n6] = jSONArray.getLong(n6);
            }
            if (this.zzJo == null) {
                bl = true;
            } else if (this.zzJo.length != n2) {
                bl = true;
            } else {
                for (n6 = 0; n6 < n2; ++n6) {
                    if (this.zzJo[n6] == lArray[n6]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzJo = lArray;
            }
        } else if (this.zzJo != null) {
            bl = true;
        }
        if (bl) {
            this.zzJo = lArray;
            n3 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzIX = jSONObject.getJSONObject("customData");
            n3 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzIY = new MediaInfo(jSONObject3);
            n3 |= 2;
            if (jSONObject3.has("metadata")) {
                n3 |= 4;
            }
        }
        return n3;
    }
}

