/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzma;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzHf;
    private int zzJp;
    private String zzIQ;
    private String zzIS;
    private String mName;
    private String zzIO;
    private int zzJq;
    private JSONObject zzIX;

    MediaTrack(JSONObject json) throws JSONException {
        this.zzd(json);
    }

    MediaTrack(long id, int type) throws IllegalArgumentException {
        this.clear();
        this.zzHf = id;
        if (type <= 0 || type > 3) {
            throw new IllegalArgumentException("invalid type " + type);
        }
        this.zzJp = type;
    }

    public long getId() {
        return this.zzHf;
    }

    public int getType() {
        return this.zzJp;
    }

    public String getContentId() {
        return this.zzIQ;
    }

    public void setContentId(String contentId) {
        this.zzIQ = contentId;
    }

    public String getContentType() {
        return this.zzIS;
    }

    public void setContentType(String contentType) {
        this.zzIS = contentType;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String name) {
        this.mName = name;
    }

    public String getLanguage() {
        return this.zzIO;
    }

    void setLanguage(String language) {
        this.zzIO = language;
    }

    public int getSubtype() {
        return this.zzJq;
    }

    void zzaf(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException("invalid subtype " + n);
        }
        if (n != 0 && this.zzJp != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzJq = n;
    }

    public JSONObject getCustomData() {
        return this.zzIX;
    }

    void setCustomData(JSONObject customData) {
        this.zzIX = customData;
    }

    private void clear() {
        this.zzHf = 0L;
        this.zzJp = 0;
        this.zzIQ = null;
        this.mName = null;
        this.zzIO = null;
        this.zzJq = -1;
        this.zzIX = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zzd(JSONObject jSONObject) throws JSONException {
        this.clear();
        this.zzHf = jSONObject.getLong("trackId");
        String string = jSONObject.getString("type");
        if ("TEXT".equals(string)) {
            this.zzJp = 1;
        } else if ("AUDIO".equals(string)) {
            this.zzJp = 2;
        } else {
            if (!"VIDEO".equals(string)) throw new JSONException("invalid type: " + string);
            this.zzJp = 3;
        }
        this.zzIQ = jSONObject.optString("trackContentId", null);
        this.zzIS = jSONObject.optString("trackContentType", null);
        this.mName = jSONObject.optString("name", null);
        this.zzIO = jSONObject.optString("language", null);
        if (jSONObject.has("subtype")) {
            string = jSONObject.getString("subtype");
            if ("SUBTITLES".equals(string)) {
                this.zzJq = 1;
            } else if ("CAPTIONS".equals(string)) {
                this.zzJq = 2;
            } else if ("DESCRIPTIONS".equals(string)) {
                this.zzJq = 3;
            } else if ("CHAPTERS".equals(string)) {
                this.zzJq = 4;
            } else {
                if (!"METADATA".equals(string)) throw new JSONException("invalid subtype: " + string);
                this.zzJq = 5;
            }
        } else {
            this.zzJq = 0;
        }
        this.zzIX = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzHf);
            switch (this.zzJp) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzIQ != null) {
                jSONObject.put("trackContentId", (Object)this.zzIQ);
            }
            if (this.zzIS != null) {
                jSONObject.put("trackContentType", (Object)this.zzIS);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzIO)) {
                jSONObject.put("language", (Object)this.zzIO);
            }
            switch (this.zzJq) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzIX != null) {
                jSONObject.put("customData", (Object)this.zzIX);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)other;
        if (this.zzIX == null != (mediaTrack.zzIX == null)) {
            return false;
        }
        if (this.zzIX != null && mediaTrack.zzIX != null && !zzma.zzd((Object)this.zzIX, (Object)mediaTrack.zzIX)) {
            return false;
        }
        return this.zzHf == mediaTrack.zzHf && this.zzJp == mediaTrack.zzJp && zzjv.zza(this.zzIQ, mediaTrack.zzIQ) && zzjv.zza(this.zzIS, mediaTrack.zzIS) && zzjv.zza(this.mName, mediaTrack.mName) && zzjv.zza(this.zzIO, mediaTrack.zzIO) && this.zzJq == mediaTrack.zzJq;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzHf, this.zzJp, this.zzIQ, this.zzIS, this.mName, this.zzIO, this.zzJq, this.zzIX});
    }

    public static class Builder {
        private final MediaTrack zzJr;

        public Builder(long trackId, int trackType) throws IllegalArgumentException {
            this.zzJr = new MediaTrack(trackId, trackType);
        }

        public Builder setContentId(String contentId) {
            this.zzJr.setContentId(contentId);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.zzJr.setContentType(contentType);
            return this;
        }

        public Builder setName(String trackName) {
            this.zzJr.setName(trackName);
            return this;
        }

        public Builder setLanguage(String language) {
            this.zzJr.setLanguage(language);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzJr.setLanguage(zzjv.zzb(locale));
            return this;
        }

        public Builder setSubtype(int subtype) throws IllegalArgumentException {
            this.zzJr.zzaf(subtype);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzJr.setCustomData(customData);
            return this;
        }

        public MediaTrack build() {
            return this.zzJr;
        }
    }
}

