/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import java.io.IOException;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zznh = new Object();
    private final zzkd zzJs;
    private final zza zzJt = new zza();
    private OnMetadataUpdatedListener zzJu;
    private OnStatusUpdatedListener zzJv;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.zzJs = new zzkd(null){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.zzJs.zza(this.zzJt);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, customData);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zzb(this.zzJN, customData);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zzc(this.zzJN, customData);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        if (trackIds == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, trackIds);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zzju zzju2) {
                Object object = RemoteMediaPlayer.this.zznh;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzJt.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzJs.zza(this.zzJN, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.setResult(this.zzj(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzJt.zzb(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzJs.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzJs.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzJs.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zznh;
        synchronized (object) {
            return this.zzJs.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.zzJv = listener;
    }

    private void onStatusUpdated() {
        if (this.zzJv != null) {
            this.zzJv.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.zzJu = listener;
    }

    private void onMetadataUpdated() {
        if (this.zzJu != null) {
            this.zzJu.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.zzJs.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.zzJs.zzaI(message);
    }

    private static abstract class zzb
    extends zzjr<MediaChannelResult> {
        zzkf zzJN = new zzkf(){

            @Override
            public void zzn(long l) {
                zzb.this.setResult(zzb.this.zzj(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.setResult(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzj(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzj(x0);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzHb;
        private final JSONObject zzIX;

        zzc(Status status, JSONObject jSONObject) {
            this.zzHb = status;
            this.zzIX = jSONObject;
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzIX;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzke {
        private GoogleApiClient zzJJ;
        private long zzJK = 0L;

        public void zzb(GoogleApiClient googleApiClient) {
            this.zzJJ = googleApiClient;
        }

        @Override
        public long zzhk() {
            return ++this.zzJK;
        }

        @Override
        public void zza(String string, String string2, long l, String string3) throws IOException {
            if (this.zzJJ == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzJJ, string, string2).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzJL;

            zza(long l) {
                this.zzJL = l;
            }

            public void zzi(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzJs.zzb(this.zzJL, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzi((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

