/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkc;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzju
extends zzk<zzjz> {
    private static final zzkc zzKh = new zzkc("CastClientImpl");
    private ApplicationMetadata zzKi;
    private final CastDevice zzKj;
    private final Cast.Listener zzIB;
    private final Map<String, Cast.MessageReceivedCallback> zzKk;
    private final long zzKl;
    private zzc zzKm;
    private String zzKn;
    private boolean zzJn;
    private boolean zzKo;
    private boolean zzKp;
    private boolean zzKq;
    private double zzJm;
    private int zzKr;
    private int zzKs;
    private final AtomicLong zzKt;
    private String zzKu;
    private String zzKv;
    private Bundle zzKw;
    private final Map<Long, zza.zzb<Status>> zzKx;
    private final zzb zzKy;
    private zza.zzb<Cast.ApplicationConnectionResult> zzKz;
    private zza.zzb<Status> zzKA;
    private static final Object zzKB = new Object();
    private static final Object zzKC = new Object();

    public zzju(Context context, Looper looper, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, connectionCallbacks, onConnectionFailedListener);
        this.zzKj = castDevice;
        this.zzIB = listener;
        this.zzKl = l;
        this.zzKk = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzKt = new AtomicLong(0L);
        this.zzKx = new HashMap<Long, zza.zzb<Status>>();
        this.zzho();
        this.zzKy = new zzb();
        this.registerConnectionFailedListener(this.zzKy);
    }

    private void zzho() {
        this.zzKq = false;
        this.zzKr = -1;
        this.zzKs = -1;
        this.zzKi = null;
        this.zzKn = null;
        this.zzJm = 0.0;
        this.zzJn = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        zzKh.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzKq = true;
            this.zzKo = true;
            this.zzKp = true;
        } else {
            this.zzKq = false;
        }
        int n2 = n;
        if (n == 1001) {
            this.zzKw = new Bundle();
            this.zzKw.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n2 = 0;
        }
        super.zza(n2, iBinder, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzKh.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzKm, this.isConnected());
        zzc zzc2 = this.zzKm;
        this.zzKm = null;
        if (zzc2 == null || zzc2.zzhy() == null) {
            zzKh.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzht();
        try {
            if (this.isConnected() || this.isConnecting()) {
                ((zzjz)this.zzjb()).disconnect();
            }
        }
        catch (RemoteException remoteException) {
            zzKh.zza(remoteException, "Error while disconnecting the controller interface: %s", remoteException.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzhp() {
        if (this.zzKw != null) {
            Bundle bundle = this.zzKw;
            this.zzKw = null;
            return bundle;
        }
        return super.zzhp();
    }

    protected String zzcF() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzcG() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzjz zzO(IBinder iBinder) {
        return zzjz.zza.zzP(iBinder);
    }

    protected Bundle zzhq() {
        Bundle bundle = new Bundle();
        zzKh.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzKu, this.zzKv);
        this.zzKj.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzKl);
        this.zzKm = new zzc(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzKm.asBinder()));
        if (this.zzKu != null) {
            bundle.putString("last_application_id", this.zzKu);
            if (this.zzKv != null) {
                bundle.putString("last_session_id", this.zzKv);
            }
        }
        return bundle;
    }

    public void zza(String string, String string2, zza.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string2.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzjv.zzaK(string);
        this.zzhu();
        long l = this.zzKt.incrementAndGet();
        try {
            this.zzKx.put(l, zzb2);
            ((zzjz)this.zzjb()).zza(string, string2, l);
        }
        catch (Throwable throwable) {
            this.zzKx.remove(l);
            throw throwable;
        }
    }

    public void zza(String string, boolean bl, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzjz)this.zzjb()).zzf(string, bl);
    }

    public void zza(String string, LaunchOptions launchOptions, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzjz)this.zzjb()).zza(string, launchOptions);
    }

    public void zzb(String string, String string2, zza.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzjz)this.zzjb()).zzo(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zza.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzKB;
        synchronized (object) {
            if (this.zzKz != null) {
                this.zzKz.zzd((Object)new zza(new Status(2002)));
            }
            this.zzKz = zzb2;
        }
    }

    public void zzd(zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzjz)this.zzjb()).zzhD();
    }

    public void zza(String string, zza.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzjz)this.zzjb()).zzaM(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zze(zza.zzb<Status> zzb2) {
        Object object = zzKC;
        synchronized (object) {
            if (this.zzKA != null) {
                zzb2.zzd((Object)new Status(2001));
                return;
            }
            this.zzKA = zzb2;
        }
    }

    public void zzhr() throws IllegalStateException, RemoteException {
        ((zzjz)this.zzjb()).zzhr();
    }

    public void zza(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzjz)this.zzjb()).zza(d, this.zzJm, this.zzJn);
    }

    public void zzL(boolean bl) throws IllegalStateException, RemoteException {
        ((zzjz)this.zzjb()).zza(bl, this.zzJm, this.zzJn);
    }

    public double zzhs() throws IllegalStateException {
        this.zzhu();
        return this.zzJm;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzhu();
        return this.zzJn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzjv.zzaK(string);
        this.zzaJ(string);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzKk;
            synchronized (map) {
                this.zzKk.put(string, messageReceivedCallback);
            }
            ((zzjz)this.zzjb()).zzaN(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzaJ(String string) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzKk;
        synchronized (map) {
            messageReceivedCallback = this.zzKk.remove(string);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzjz)this.zzjb()).zzaO(string);
            }
            catch (IllegalStateException illegalStateException) {
                zzKh.zza(illegalStateException, "Error unregistering namespace (%s): %s", string, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzhu();
        return this.zzKi;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzhu();
        return this.zzKn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzht() {
        zzKh.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzKk;
        synchronized (map) {
            this.zzKk.clear();
        }
    }

    private void zza(zzjw zzjw2) {
        boolean bl;
        ApplicationMetadata applicationMetadata = zzjw2.getApplicationMetadata();
        if (!zzjv.zza(applicationMetadata, this.zzKi)) {
            this.zzKi = applicationMetadata;
            this.zzIB.onApplicationMetadataChanged(this.zzKi);
        }
        boolean bl2 = false;
        double d = zzjw2.zzhs();
        if (d != Double.NaN && Math.abs(d - this.zzJm) > 1.0E-7) {
            this.zzJm = d;
            bl2 = true;
        }
        if ((bl = zzjw2.zzhA()) != this.zzJn) {
            this.zzJn = bl;
            bl2 = true;
        }
        zzKh.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzKp);
        if (this.zzIB != null && (bl2 || this.zzKp)) {
            this.zzIB.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = zzjw2.zzhB();
        if (n != this.zzKr) {
            this.zzKr = n;
            bl3 = true;
        }
        zzKh.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzKp);
        if (this.zzIB != null && (bl3 || this.zzKp)) {
            this.zzIB.zzab(this.zzKr);
        }
        boolean bl4 = false;
        int n2 = zzjw2.zzhC();
        if (n2 != this.zzKs) {
            this.zzKs = n2;
            bl4 = true;
        }
        zzKh.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzKp);
        if (this.zzIB != null && (bl4 || this.zzKp)) {
            this.zzIB.zzac(this.zzKs);
        }
        this.zzKp = false;
    }

    private void zza(zzjp zzjp2) {
        boolean bl = false;
        String string = zzjp2.zzhl();
        if (!zzjv.zza(string, this.zzKn)) {
            this.zzKn = string;
            bl = true;
        }
        zzKh.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzKo);
        if (this.zzIB != null && (bl || this.zzKo)) {
            this.zzIB.onApplicationStatusChanged();
        }
        this.zzKo = false;
    }

    private void zzhu() throws IllegalStateException {
        if (!this.zzKq || this.zzKm == null || this.zzKm.zzhz()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzp(IBinder iBinder) {
        return this.zzO(iBinder);
    }

    private static class zzc
    extends zzka.zza {
        private final AtomicReference<zzju> zzKH;
        private final Handler mHandler;

        public zzc(zzju zzju2) {
            this.zzKH = new AtomicReference<zzju>(zzju2);
            this.mHandler = new Handler(zzju2.getLooper());
        }

        public zzju zzhy() {
            zzju zzju2 = this.zzKH.getAndSet(null);
            if (zzju2 == null) {
                return null;
            }
            zzju2.zzho();
            return zzju2;
        }

        public boolean zzhz() {
            return this.zzKH.get() == null;
        }

        @Override
        public void zzai(int n) {
            zzju zzju2 = this.zzhy();
            if (zzju2 == null) {
                return;
            }
            zzKh.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zzju2.zzaI(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzju2.zzKi = applicationMetadata;
            zzju2.zzKu = applicationMetadata.getApplicationId();
            zzju2.zzKv = string2;
            Object object = zzKB;
            synchronized (object) {
                if (zzju2.zzKz != null) {
                    zzju2.zzKz.zzd((Object)new zza(new Status(0), applicationMetadata, string, string2, bl));
                    zzju2.zzKz = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzaj(int n) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            Object object = zzKB;
            synchronized (object) {
                if (zzju2.zzKz != null) {
                    zzju2.zzKz.zzd((Object)new zza(new Status(n)));
                    zzju2.zzKz = null;
                }
            }
        }

        @Override
        public void zzak(int n) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            this.zza(zzju2, n);
        }

        @Override
        public void zzal(int n) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            this.zza(zzju2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzju2.zzKu = null;
            zzju2.zzKv = null;
            this.zza(zzju2, statusCode);
            if (zzju2.zzIB != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zzju2.zzIB != null) {
                            zzju2.zzIB.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string, double d, boolean bl) {
            zzKh.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final zzjw zzjw2) {
            final zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzKh.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zzju2.zza(zzjw2);
                }
            });
        }

        @Override
        public void zzb(final zzjp zzjp2) {
            final zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzKh.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zzju2.zza(zzjp2);
                }
            });
        }

        @Override
        public void zzn(final String string, final String string2) {
            final zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzKh.zzb("Receive (type=text, ns=%s) %s", string, string2);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zzju2.zzKk;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zzju2.zzKk.get(string);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zzju2.zzKj, string, string2);
                    } else {
                        zzKh.zzb("Discarded message for unknown namespace '%s'", string);
                    }
                }
            });
        }

        @Override
        public void zzb(String string, byte[] byArray) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            zzKh.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string, byArray.length);
        }

        @Override
        public void zza(String string, long l, int n) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            this.zza(zzju2, l, n);
        }

        @Override
        public void zza(String string, long l) {
            zzju zzju2 = this.zzKH.get();
            if (zzju2 == null) {
                return;
            }
            this.zza(zzju2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zzju zzju2, long l, int n) {
            zza.zzb zzb2;
            Map map = zzju2.zzKx;
            synchronized (map) {
                zzb2 = (zza.zzb)zzju2.zzKx.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzd((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zzju zzju2, int n) {
            Object object = zzKC;
            synchronized (object) {
                if (zzju2.zzKA != null) {
                    zzju2.zzKA.zzd((Object)new Status(n));
                    zzju2.zzKA = null;
                    return true;
                }
            }
            return false;
        }
    }

    private class zzb
    implements GoogleApiClient.OnConnectionFailedListener {
        private zzb() {
        }

        public void onConnectionFailed(ConnectionResult result) {
            zzju.this.zzht();
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzHb;
        private final ApplicationMetadata zzKD;
        private final String zzKE;
        private final String zzyL;
        private final boolean zzKF;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string, String string2, boolean bl) {
            this.zzHb = status;
            this.zzKD = applicationMetadata;
            this.zzKE = string;
            this.zzyL = string2;
            this.zzKF = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzHb;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzKD;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzKE;
        }

        @Override
        public String getSessionId() {
            return this.zzyL;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzKF;
        }
    }
}

