/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzkc;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzkh {
    private static final zzkc zzKh = new zzkc("MetadataUtils");
    private static final String[] zzLn = new String[]{"Z", "+hh", "+hhmm", "+hh:mm"};
    private static final String zzLo = "yyyyMMdd'T'HHmmss" + zzLn[0];

    public static void zza(List<WebImage> list, JSONObject jSONObject) {
        try {
            list.clear();
            JSONArray jSONArray = jSONObject.getJSONArray("images");
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                try {
                    list.add(new WebImage(jSONObject2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void zza(JSONObject jSONObject, List<WebImage> list) {
        if (list != null && !list.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (WebImage webImage : list) {
                jSONArray.put((Object)webImage.toJson());
            }
            try {
                jSONObject.put("images", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static String zza(Calendar calendar) {
        if (calendar == null) {
            zzKh.zzb("Calendar object cannot be null", new Object[0]);
            return null;
        }
        String string = zzLo;
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string = "yyyyMMdd";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String string2 = simpleDateFormat.format(calendar.getTime());
        if (string2.endsWith("+0000")) {
            string2 = string2.replace("+0000", zzLn[0]);
        }
        return string2;
    }

    public static Calendar zzaQ(String string) {
        Date date;
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzKh.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        String string2 = zzkh.zzaR(string);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzKh.zzb("Invalid date format", new Object[0]);
            return null;
        }
        String string3 = zzkh.zzaS(string);
        String string4 = "yyyyMMdd";
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string2 = string2 + "T" + string3;
            string4 = string3.length() == "HHmmss".length() ? "yyyyMMdd'T'HHmmss" : zzLo;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        try {
            date = new SimpleDateFormat(string4).parse(string2);
        }
        catch (ParseException parseException) {
            zzKh.zzb("Error parsing string: %s", parseException.getMessage());
            return null;
        }
        calendar.setTime(date);
        return calendar;
    }

    private static String zzaR(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzKh.zzb("Input string is empty or null", new Object[0]);
            return null;
        }
        try {
            return string.substring(0, "yyyyMMdd".length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzKh.zzc("Error extracting the date: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
    }

    private static String zzaS(String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzKh.zzb("string is empty or null", new Object[0]);
            return null;
        }
        int n = string.indexOf(84);
        if (n++ != "yyyyMMdd".length()) {
            zzKh.zzb("T delimeter is not found", new Object[0]);
            return null;
        }
        try {
            string2 = string.substring(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzKh.zzb("Error extracting the time substring: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
        if (string2.length() == "HHmmss".length()) {
            return string2;
        }
        char c = string2.charAt("HHmmss".length());
        switch (c) {
            case 'Z': {
                if (string2.length() == "HHmmss".length() + zzLn[0].length()) {
                    return string2.substring(0, string2.length() - 1) + "+0000";
                }
                return null;
            }
            case '+': 
            case '-': {
                if (!zzkh.zzaT(string2)) break;
                return string2.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
            }
        }
        return null;
    }

    private static boolean zzaT(String string) {
        int n;
        int n2 = string.length();
        return n2 == (n = "HHmmss".length()) + zzLn[1].length() || n2 == n + zzLn[2].length() || n2 == n + zzLn[3].length();
    }
}

