/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int zzzH;
    String zzLD;
    String mName;
    List<WebImage> zzLE;
    List<String> zzLF;
    String zzLG;
    Uri zzLH;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.zzzH = versionCode;
        this.zzLD = applicationId;
        this.mName = name;
        this.zzLE = images;
        this.zzLF = namespaces;
        this.zzLG = senderAppIdentifier;
        this.zzLH = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.zzzH = 1;
        this.zzLE = new ArrayList<WebImage>();
        this.zzLF = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.zzzH;
    }

    public String getApplicationId() {
        return this.zzLD;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzLF != null && this.zzLF.contains(namespace);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzLF != null && this.zzLF.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzLG;
    }

    public Uri zzjR() {
        return this.zzLH;
    }

    public List<WebImage> getImages() {
        return this.zzLE;
    }

    public String toString() {
        return "applicationId: " + this.zzLD + ", name: " + this.mName + ", images.count: " + (this.zzLE == null ? 0 : this.zzLE.size()) + ", namespaces.count: " + (this.zzLF == null ? 0 : this.zzLF.size()) + ", senderAppIdentifier: " + this.zzLG + ", senderAppLaunchUrl: " + this.zzLH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzu.hashCode((Object[])new Object[]{this.zzzH, this.zzLD, this.mName, this.zzLE, this.zzLF, this.zzLG, this.zzLH});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzf.zza(this.zzLD, applicationMetadata.zzLD) && zzf.zza(this.zzLE, applicationMetadata.zzLE) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzLF, applicationMetadata.zzLF) && zzf.zza(this.zzLG, applicationMetadata.zzLG) && zzf.zza(this.zzLH, applicationMetadata.zzLH);
    }
}

