/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.internal.zzjt;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjx;
import com.google.android.gms.internal.zzjy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzjs
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzbE("com.google.cast.games");
    private static final zzl zzQW = new zzl("GameManagerChannel");
    private final Map<String, String> zzTn = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzTo;
    private final SharedPreferences zztB;
    private final String zzTp;
    private final Cast.CastApi zzTq;
    private final GoogleApiClient zzTr;
    private zzjt zzTs;
    private boolean zzTt = false;
    private GameManagerState zzTu;
    private GameManagerState zzTv;
    private String zzTw;
    private JSONObject zzTx;
    private long zzTy = 0L;
    private GameManagerClient.Listener zzTz;
    private String zzTA;

    public zzjs(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzTo = new ArrayList<zzp>();
        this.zzTp = string2;
        this.zzTq = castApi;
        this.zzTr = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zztB = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzTv = null;
        this.zzTu = new zzjw(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzTr.zzb((zza.zza)new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzjs.this.zzTq.setMessageReceivedCallbacks(zzjs.this.zzTr, zzjs.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                            zzjs.this.zzbB(message);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzlA().zza(-1L, 8, null);
                    return;
                }
                zzjs.this.zzly();
                zzjs.this.zzlx();
                zzjs.this.zza(null, 1100, null, this.zzlA());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzTt) {
            return;
        }
        this.zzTu = null;
        this.zzTv = null;
        this.zzTw = null;
        this.zzTx = null;
        this.zzTt = true;
        try {
            this.zzTq.removeMessageReceivedCallbacks(this.zzTr, this.getNamespace());
        }
        catch (IOException iOException) {
            zzQW.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzlv();
        return this.zzTr.zzb((zza.zza)new zza(){

            @Override
            public void execute() {
                int n2 = zzjv.zzaJ(n);
                if (n2 == 0) {
                    this.zzlA().zza(-1L, 2001, null);
                    zzQW.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzjs.this.zza(string2, n2, jSONObject, this.zzlA());
            }
        });
    }

    public synchronized void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zzlv();
        long l = ++this.zzTy;
        JSONObject jSONObject = this.zza(l, playerId, 7, extraMessageData);
        if (jSONObject == null) {
            return;
        }
        this.zzTq.sendMessage(this.zzTr, this.getNamespace(), jSONObject.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String playerId, final JSONObject extraMessageData) throws IllegalStateException {
        this.zzlv();
        return this.zzTr.zzb((zza.zza)new zza(){

            @Override
            public void execute() {
                zzjs.this.zza(playerId, 6, extraMessageData, this.zzlA());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzlv();
        return this.zzTu;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzlv();
        return this.zzTA;
    }

    public synchronized String zzbA(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzTn.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzTz = listener;
    }

    @Override
    public final void zzbB(String string2) {
        boolean bl;
        zzju zzju2;
        zzQW.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzju2 = zzju.zzh(jSONObject);
        }
        catch (JSONException jSONException) {
            zzQW.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzju2 == null) {
            zzQW.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzju2.zzlH() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzju2.zzlC() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzju2.zzlG())) {
            this.zzTn.put(zzju2.getPlayerId(), zzju2.zzlG());
            this.zzlx();
        }
        if (zzju2.getStatusCode() == 0) {
            this.zza(zzju2);
        } else {
            zzQW.zzf("Not updating from game message because the message contains error code: %d", zzju2.getStatusCode());
        }
        int n = this.zzaI(zzju2.getStatusCode());
        if (bl) {
            this.zzb(zzju2.getRequestId(), n, zzju2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzlw();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzTt;
    }

    public synchronized boolean isInitialized() {
        return this.zzTs != null;
    }

    @Override
    public void zzb(long l, int n) {
        this.zzb(l, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l) {
        Iterator<zzp> iterator = this.zzTo.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zzVr;
        synchronized (object) {
            for (zzp zzp3 : this.zzTo) {
                if (!zzp3.zzme()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzaI(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzQW.zzf("Unknown GameManager protocol status code: " + n, new Object[0]);
        return 13;
    }

    private synchronized void zzlv() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzo zzo2) {
        long l;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l = ++this.zzTy, string2, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzQW.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l, zzo2);
        this.zzTo.add(zzp2);
        this.zzQ(true);
        this.zzTq.sendMessage(this.zzTr, this.getNamespace(), jSONObject2.toString()).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzm(Status status) {
                if (!status.isSuccess()) {
                    zzjs.this.zzb(l, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzm((Status)x0);
            }
        });
    }

    private JSONObject zza(long l, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzbA(string2));
        }
        catch (JSONException jSONException) {
            zzQW.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzju zzju2) {
        boolean bl = zzju2.zzlC() == 1;
        this.zzTv = this.zzTu;
        if (bl && zzju2.zzlH() != null) {
            this.zzTs = zzju2.zzlH();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzjy zzjy2 : zzju2.zzlE()) {
            String string2 = zzjy2.getPlayerId();
            zzjx zzjx2 = new zzjx(string2, zzjy2.getPlayerState(), zzjy2.getPlayerData(), this.zzTn.containsKey(string2));
            arrayList.add(zzjx2);
        }
        this.zzTu = new zzjw(zzju2.getLobbyState(), zzju2.getGameplayState(), zzju2.zzlF(), zzju2.getGameData(), arrayList, this.zzTs.zzlB(), this.zzTs.getMaxPlayers());
        PlayerInfo playerInfo = this.zzTu.getPlayer(zzju2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzju2.zzlC() == 2) {
            this.zzTw = zzju2.getPlayerId();
            this.zzTx = zzju2.getExtraMessageData();
        }
    }

    private void zzlw() {
        if (this.zzTz != null) {
            if (this.zzTv != null && !this.zzTu.equals(this.zzTv)) {
                this.zzTz.onStateChanged(this.zzTu, this.zzTv);
            }
            if (this.zzTx != null && this.zzTw != null) {
                this.zzTz.onGameMessageReceived(this.zzTw, this.zzTx);
            }
        }
        this.zzTv = null;
        this.zzTw = null;
        this.zzTx = null;
    }

    private void zzb(long l, int n, Object object) {
        Iterator<zzp> iterator = this.zzTo.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzlx() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzTp);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzTn));
            this.zztB.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzQW.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzly() {
        String string2 = this.zztB.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzTp.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzTn.put(string4, jSONObject2.getString(string4));
                }
                this.zzTy = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzQW.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzTa = new zzo(){

                @Override
                public void zzy(long l) {
                    zza.this.setResult(zza.this.zzo(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.setResult(new zze(new Status(n, null, null), null, l, null));
                            return;
                        }
                        zzju zzju2 = (zzju)object;
                        String string2 = zzju2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzjs.this.zzTA = string2;
                        }
                        zza.this.setResult(new zze(new Status(n, zzju2.zzlD(), null), string2, zzju2.getRequestId(), zzju2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.setResult(zza.this.zzo(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzo(Status status) {
            return new zze(status, null, -1L, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzo(x0);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzTJ;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzTJ = gameManagerClient;
            this.zzTa = new zzo(){

                @Override
                public void zzy(long l) {
                    zzc.this.setResult(zzc.this.zzp(new Status(2103)));
                }

                @Override
                public void zza(long l, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.setResult(new zzd(new Status(n, null, null), zzc.this.zzTJ));
                            return;
                        }
                        zzju zzju2 = (zzju)object;
                        zzjt zzjt2 = zzju2.zzlH();
                        if (zzjt2 != null && !zzf.zza("1.0.0", zzjt2.getVersion())) {
                            zzc.this.setResult(zzc.this.zzp(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzjt2.getVersion(), "1.0.0"))));
                            zzjs.this.zzTs = null;
                            return;
                        }
                        zzc.this.setResult(new zzd(new Status(n, zzju2.zzlD(), null), zzc.this.zzTJ));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.setResult(zzc.this.zzp(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzp(Status status) {
            return new zzd(status, null);
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzp(x0);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzTa;

        public zzb() {
            super(zzjs.this.zzTr);
        }

        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zzlA() {
            return this.zzTa;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzOt;
        private final String zzTL;
        private final long zzTM;
        private final JSONObject zzTN;

        zze(Status status, String string2, long l, JSONObject jSONObject) {
            this.zzOt = status;
            this.zzTL = string2;
            this.zzTM = l;
            this.zzTN = jSONObject;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public String getPlayerId() {
            return this.zzTL;
        }

        @Override
        public long getRequestId() {
            return this.zzTM;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzTN;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzOt;
        private final GameManagerClient zzTJ;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzOt = status;
            this.zzTJ = gameManagerClient;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzTJ;
        }
    }
}

