/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzmu;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzVV;
    private int zzVW;
    private String zzVX;
    private MediaMetadata zzVY;
    private long zzVZ;
    private List<MediaTrack> zzWa;
    private TextTrackStyle zzWb;
    private JSONObject zzWc;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzVV = contentId;
        this.zzVW = -1;
        this.zzVZ = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzVV = json.getString("contentId");
        String string = json.getString("streamType");
        this.zzVW = "NONE".equals(string) ? 0 : ("BUFFERED".equals(string) ? 1 : ("LIVE".equals(string) ? 2 : -1));
        this.zzVX = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzVY = new MediaMetadata(n);
            this.zzVY.zzf(jSONObject);
        }
        this.zzVZ = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzVZ = zzf.zzg(d);
        }
        if (json.has("tracks")) {
            this.zzWa = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzWa.add(mediaTrack);
            }
        } else {
            this.zzWa = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzf(jSONObject);
            this.zzWb = textTrackStyle;
        } else {
            this.zzWb = null;
        }
        this.zzWc = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzVV;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzVW = streamType;
    }

    public int getStreamType() {
        return this.zzVW;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzVX = contentType;
    }

    public String getContentType() {
        return this.zzVX;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzVY = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzVY;
    }

    void zzx(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzVZ = l;
    }

    public long getStreamDuration() {
        return this.zzVZ;
    }

    void zzq(List<MediaTrack> list) {
        this.zzWa = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzWa;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzWb = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzWb;
    }

    void setCustomData(JSONObject customData) {
        this.zzWc = customData;
    }

    public JSONObject getCustomData() {
        return this.zzWc;
    }

    void zzmx() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzVV)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzVX)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzVW == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string;
            jSONObject.put("contentId", (Object)this.zzVV);
            switch (this.zzVW) {
                case 1: {
                    string = "BUFFERED";
                    break;
                }
                case 2: {
                    string = "LIVE";
                    break;
                }
                default: {
                    string = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string);
            if (this.zzVX != null) {
                jSONObject.put("contentType", (Object)this.zzVX);
            }
            if (this.zzVY != null) {
                jSONObject.put("metadata", (Object)this.zzVY.toJson());
            }
            if (this.zzVZ <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzA(this.zzVZ));
            }
            if (this.zzWa != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzWa) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzWb != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzWb.toJson());
            }
            if (this.zzWc != null) {
                jSONObject.put("customData", (Object)this.zzWc);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzWc == null != (mediaInfo.zzWc == null)) {
            return false;
        }
        if (this.zzWc != null && mediaInfo.zzWc != null && !zzmu.zzd((Object)this.zzWc, (Object)mediaInfo.zzWc)) {
            return false;
        }
        return zzf.zza(this.zzVV, mediaInfo.zzVV) && this.zzVW == mediaInfo.zzVW && zzf.zza(this.zzVX, mediaInfo.zzVX) && zzf.zza(this.zzVY, mediaInfo.zzVY) && this.zzVZ == mediaInfo.zzVZ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzVV, this.zzVW, this.zzVX, this.zzVY, this.zzVZ, String.valueOf(this.zzWc)});
    }

    public static class Builder {
        private final MediaInfo zzWd;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzWd = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzWd.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzWd.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzWd.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzWd.zzx(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzWd.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzWd.zzq(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzWd.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzWd.zzmx();
            return this.zzWd;
        }
    }
}

