/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zza;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationMetadata
implements SafeParcelable {
    public static final Parcelable.Creator<ApplicationMetadata> CREATOR = new zza();
    private final int mVersionCode;
    String zzXW;
    String mName;
    List<WebImage> zzxz;
    List<String> zzXX;
    String zzXY;
    Uri zzXZ;

    ApplicationMetadata(int versionCode, String applicationId, String name, List<WebImage> images, List<String> namespaces, String senderAppIdentifier, Uri senderAppLaunchUrl) {
        this.mVersionCode = versionCode;
        this.zzXW = applicationId;
        this.mName = name;
        this.zzxz = images;
        this.zzXX = namespaces;
        this.zzXY = senderAppIdentifier;
        this.zzXZ = senderAppLaunchUrl;
    }

    private ApplicationMetadata() {
        this.mVersionCode = 1;
        this.zzxz = new ArrayList<WebImage>();
        this.zzXX = new ArrayList<String>();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getApplicationId() {
        return this.zzXW;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isNamespaceSupported(String namespace) {
        return this.zzXX != null && this.zzXX.contains(namespace);
    }

    public boolean areNamespacesSupported(List<String> namespaces) {
        return this.zzXX != null && this.zzXX.containsAll(namespaces);
    }

    public String getSenderAppIdentifier() {
        return this.zzXY;
    }

    public Uri zznh() {
        return this.zzXZ;
    }

    public List<WebImage> getImages() {
        return this.zzxz;
    }

    public String toString() {
        return "applicationId: " + this.zzXW + ", name: " + this.mName + ", images.count: " + (this.zzxz == null ? 0 : this.zzxz.size()) + ", namespaces.count: " + (this.zzXX == null ? 0 : this.zzXX.size()) + ", senderAppIdentifier: " + this.zzXY + ", senderAppLaunchUrl: " + this.zzXZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.mVersionCode, this.zzXW, this.mName, this.zzxz, this.zzXX, this.zzXY, this.zzXZ});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationMetadata)) {
            return false;
        }
        ApplicationMetadata applicationMetadata = (ApplicationMetadata)obj;
        return zzf.zza(this.zzXW, applicationMetadata.zzXW) && zzf.zza(this.zzxz, applicationMetadata.zzxz) && zzf.zza(this.mName, applicationMetadata.mName) && zzf.zza(this.zzXX, applicationMetadata.zzXX) && zzf.zza(this.zzXY, applicationMetadata.zzXY) && zzf.zza(this.zzXZ, applicationMetadata.zzXZ);
    }
}

