/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzln;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] zzZp = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final zza zzZq = new zza().zzc("com.google.android.gms.cast.metadata.CREATION_DATE", "creationDateTime", 4).zzc("com.google.android.gms.cast.metadata.RELEASE_DATE", "releaseDate", 4).zzc("com.google.android.gms.cast.metadata.BROADCAST_DATE", "originalAirdate", 4).zzc("com.google.android.gms.cast.metadata.TITLE", "title", 1).zzc("com.google.android.gms.cast.metadata.SUBTITLE", "subtitle", 1).zzc("com.google.android.gms.cast.metadata.ARTIST", "artist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_ARTIST", "albumArtist", 1).zzc("com.google.android.gms.cast.metadata.ALBUM_TITLE", "albumName", 1).zzc("com.google.android.gms.cast.metadata.COMPOSER", "composer", 1).zzc("com.google.android.gms.cast.metadata.DISC_NUMBER", "discNumber", 2).zzc("com.google.android.gms.cast.metadata.TRACK_NUMBER", "trackNumber", 2).zzc("com.google.android.gms.cast.metadata.SEASON_NUMBER", "season", 2).zzc("com.google.android.gms.cast.metadata.EPISODE_NUMBER", "episode", 2).zzc("com.google.android.gms.cast.metadata.SERIES_TITLE", "seriesTitle", 1).zzc("com.google.android.gms.cast.metadata.STUDIO", "studio", 1).zzc("com.google.android.gms.cast.metadata.WIDTH", "width", 2).zzc("com.google.android.gms.cast.metadata.HEIGHT", "height", 2).zzc("com.google.android.gms.cast.metadata.LOCATION_NAME", "location", 1).zzc("com.google.android.gms.cast.metadata.LOCATION_LATITUDE", "latitude", 3).zzc("com.google.android.gms.cast.metadata.LOCATION_LONGITUDE", "longitude", 3);
    private final List<WebImage> zzxz = new ArrayList<WebImage>();
    private final Bundle zzZr = new Bundle();
    private int zzZs;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int mediaType) {
        this.zzZs = mediaType;
    }

    public int getMediaType() {
        return this.zzZs;
    }

    public void clear() {
        this.zzZr.clear();
        this.zzxz.clear();
    }

    public boolean containsKey(String key) {
        return this.zzZr.containsKey(key);
    }

    public Set<String> keySet() {
        return this.zzZr.keySet();
    }

    public void putString(String key, String value) {
        this.zzf(key, 1);
        this.zzZr.putString(key, value);
    }

    public String getString(String key) {
        this.zzf(key, 1);
        return this.zzZr.getString(key);
    }

    public void putInt(String key, int value) {
        this.zzf(key, 2);
        this.zzZr.putInt(key, value);
    }

    public int getInt(String key) {
        this.zzf(key, 2);
        return this.zzZr.getInt(key);
    }

    public void putDouble(String key, double value) {
        this.zzf(key, 3);
        this.zzZr.putDouble(key, value);
    }

    public double getDouble(String key) {
        this.zzf(key, 3);
        return this.zzZr.getDouble(key);
    }

    public void putDate(String key, Calendar value) {
        this.zzf(key, 4);
        this.zzZr.putString(key, zzln.zza(value));
    }

    public Calendar getDate(String key) {
        this.zzf(key, 4);
        String string2 = this.zzZr.getString(key);
        return string2 != null ? zzln.zzci(string2) : null;
    }

    public String getDateAsString(String key) {
        this.zzf(key, 4);
        return this.zzZr.getString(key);
    }

    private void zzf(String string2, int n) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n2 = zzZq.zzbW(string2);
        if (n2 != n && n2 != 0) {
            throw new IllegalArgumentException("Value for " + string2 + " must be a " + zzZp[n]);
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.zzZs);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zzln.zza(jSONObject, this.zzxz);
        switch (this.zzZs) {
            case 0: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zza(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zza(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zza(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zza(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void zzf(JSONObject jSONObject) {
        this.clear();
        this.zzZs = 0;
        try {
            this.zzZs = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        zzln.zza(this.zzxz, jSONObject);
        switch (this.zzZs) {
            case 0: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.zzb(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.zzb(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.zzb(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.zzb(jSONObject, new String[0]);
            }
        }
    }

    private void zza(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string2 : stringArray) {
                if (!this.zzZr.containsKey(string2)) continue;
                int n = zzZq.zzbW(string2);
                switch (n) {
                    case 1: 
                    case 4: {
                        jSONObject.put(zzZq.zzbU(string2), (Object)this.zzZr.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(zzZq.zzbU(string2), this.zzZr.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(zzZq.zzbU(string2), this.zzZr.getDouble(string2));
                        continue block7;
                    }
                }
            }
            for (String string3 : this.zzZr.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.zzZr.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void zzb(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = zzZq.zzbV(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (zzZq.zzbW(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.zzZr.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = zzln.zzci((String)object);
                                if (calendar == null) continue block10;
                                this.zzZr.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.zzZr.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.zzZr.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.zzZr.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.zzZr.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.zzZr.putDouble(string2, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)other;
        return this.zzb(this.zzZr, mediaMetadata.zzZr) && this.zzxz.equals(mediaMetadata.zzxz);
    }

    public int hashCode() {
        int n = 17;
        Set set = this.zzZr.keySet();
        for (String string2 : set) {
            n = 31 * n + this.zzZr.get(string2).hashCode();
        }
        n = 31 * n + this.zzxz.hashCode();
        return n;
    }

    public List<WebImage> getImages() {
        return this.zzxz;
    }

    public boolean hasImages() {
        return this.zzxz != null && !this.zzxz.isEmpty();
    }

    public void clearImages() {
        this.zzxz.clear();
    }

    public void addImage(WebImage image) {
        this.zzxz.add(image);
    }

    private boolean zzb(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string2 : set) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.zzb((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static class zza {
        private final Map<String, String> zzZt = new HashMap<String, String>();
        private final Map<String, String> zzZu = new HashMap<String, String>();
        private final Map<String, Integer> zzZv = new HashMap<String, Integer>();

        public zza zzc(String string2, String string3, int n) {
            this.zzZt.put(string2, string3);
            this.zzZu.put(string3, string2);
            this.zzZv.put(string2, n);
            return this;
        }

        public String zzbU(String string2) {
            return this.zzZt.get(string2);
        }

        public String zzbV(String string2) {
            return this.zzZu.get(string2);
        }

        public int zzbW(String string2) {
            Integer n = this.zzZv.get(string2);
            return n != null ? n : 0;
        }
    }
}

