/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.util.SparseArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.internal.zzf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaStatus {
    public static final long COMMAND_PAUSE = 1L;
    public static final long COMMAND_SEEK = 2L;
    public static final long COMMAND_SET_VOLUME = 4L;
    public static final long COMMAND_TOGGLE_MUTE = 8L;
    public static final long COMMAND_SKIP_FORWARD = 16L;
    public static final long COMMAND_SKIP_BACKWARD = 32L;
    public static final int PLAYER_STATE_UNKNOWN = 0;
    public static final int PLAYER_STATE_IDLE = 1;
    public static final int PLAYER_STATE_PLAYING = 2;
    public static final int PLAYER_STATE_PAUSED = 3;
    public static final int PLAYER_STATE_BUFFERING = 4;
    public static final int IDLE_REASON_NONE = 0;
    public static final int IDLE_REASON_FINISHED = 1;
    public static final int IDLE_REASON_CANCELED = 2;
    public static final int IDLE_REASON_INTERRUPTED = 3;
    public static final int IDLE_REASON_ERROR = 4;
    public static final int REPEAT_MODE_REPEAT_OFF = 0;
    public static final int REPEAT_MODE_REPEAT_ALL = 1;
    public static final int REPEAT_MODE_REPEAT_SINGLE = 2;
    public static final int REPEAT_MODE_REPEAT_ALL_AND_SHUFFLE = 3;
    private int zzZE = 0;
    private long zzZF;
    private MediaInfo zzZo;
    private double zzZG;
    private int zzZH;
    private int zzZI;
    private long zzZJ;
    private long zzZK;
    private double zzZL;
    private boolean zzZM;
    private long[] zzZC;
    private JSONObject zzZn;
    private int zzZN = 0;
    private int zzZO = 0;
    private final zza zzZP = new zza();

    public MediaStatus(JSONObject json) throws JSONException {
        this.zza(json, 0);
    }

    public long zznw() {
        return this.zzZF;
    }

    public int getPlayerState() {
        return this.zzZH;
    }

    public int getIdleReason() {
        return this.zzZI;
    }

    public double getPlaybackRate() {
        return this.zzZG;
    }

    public MediaInfo getMediaInfo() {
        return this.zzZo;
    }

    public long getStreamPosition() {
        return this.zzZJ;
    }

    public boolean isMediaCommandSupported(long mediaCommand) {
        return (this.zzZK & mediaCommand) != 0L;
    }

    public double getStreamVolume() {
        return this.zzZL;
    }

    public boolean isMute() {
        return this.zzZM;
    }

    public long[] getActiveTrackIds() {
        return this.zzZC;
    }

    public JSONObject getCustomData() {
        return this.zzZn;
    }

    public int getCurrentItemId() {
        return this.zzZE;
    }

    public int getLoadingItemId() {
        return this.zzZN;
    }

    public int getPreloadedItemId() {
        return this.zzZO;
    }

    public int getQueueRepeatMode() {
        return this.zzZP.getRepeatMode();
    }

    public List<MediaQueueItem> getQueueItems() {
        return this.zzZP.zznx();
    }

    public int getQueueItemCount() {
        return this.zzZP.getItemCount();
    }

    public MediaQueueItem getQueueItemById(int itemId) {
        return this.zzZP.zzbb(itemId);
    }

    public MediaQueueItem getQueueItem(int index) {
        return this.zzZP.zzbc(index);
    }

    public int zza(JSONObject jSONObject, int n) throws JSONException {
        int n2;
        int n3;
        int n4;
        long l;
        long l2;
        double d;
        int n5 = 0;
        long l3 = jSONObject.getLong("mediaSessionId");
        if (l3 != this.zzZF) {
            this.zzZF = l3;
            n5 |= 1;
        }
        if (jSONObject.has("playerState")) {
            int n6 = 0;
            String string2 = jSONObject.getString("playerState");
            if (string2.equals("IDLE")) {
                n6 = 1;
            } else if (string2.equals("PLAYING")) {
                n6 = 2;
            } else if (string2.equals("PAUSED")) {
                n6 = 3;
            } else if (string2.equals("BUFFERING")) {
                n6 = 4;
            }
            if (n6 != this.zzZH) {
                this.zzZH = n6;
                n5 |= 2;
            }
            if (n6 == 1 && jSONObject.has("idleReason")) {
                int n7 = 0;
                string2 = jSONObject.getString("idleReason");
                if (string2.equals("CANCELLED")) {
                    n7 = 2;
                } else if (string2.equals("INTERRUPTED")) {
                    n7 = 3;
                } else if (string2.equals("FINISHED")) {
                    n7 = 1;
                } else if (string2.equals("ERROR")) {
                    n7 = 4;
                }
                if (n7 != this.zzZI) {
                    this.zzZI = n7;
                    n5 |= 2;
                }
            }
        }
        if (jSONObject.has("playbackRate") && this.zzZG != (d = jSONObject.getDouble("playbackRate"))) {
            this.zzZG = d;
            n5 |= 2;
        }
        if (jSONObject.has("currentTime") && (n & 2) == 0 && (l2 = zzf.zzg(jSONObject.getDouble("currentTime"))) != this.zzZJ) {
            this.zzZJ = l2;
            n5 |= 2;
        }
        if (jSONObject.has("supportedMediaCommands") && (l = jSONObject.getLong("supportedMediaCommands")) != this.zzZK) {
            this.zzZK = l;
            n5 |= 2;
        }
        if (jSONObject.has("volume") && (n & 1) == 0) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("volume");
            double d2 = jSONObject2.getDouble("level");
            if (d2 != this.zzZL) {
                this.zzZL = d2;
                n5 |= 2;
            }
            if ((n4 = (int)(jSONObject2.getBoolean("muted") ? 1 : 0)) != this.zzZM) {
                this.zzZM = n4;
                n5 |= 2;
            }
        }
        boolean bl = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n8;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            n4 = jSONArray.length();
            lArray = new long[n4];
            for (n8 = 0; n8 < n4; ++n8) {
                lArray[n8] = jSONArray.getLong(n8);
            }
            if (this.zzZC == null) {
                bl = true;
            } else if (this.zzZC.length != n4) {
                bl = true;
            } else {
                for (n8 = 0; n8 < n4; ++n8) {
                    if (this.zzZC[n8] == lArray[n8]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.zzZC = lArray;
            }
        } else if (this.zzZC != null) {
            bl = true;
        }
        if (bl) {
            this.zzZC = lArray;
            n5 |= 2;
        }
        if (jSONObject.has("customData")) {
            this.zzZn = jSONObject.getJSONObject("customData");
            n5 |= 2;
        }
        if (jSONObject.has("media")) {
            JSONObject jSONObject3 = jSONObject.getJSONObject("media");
            this.zzZo = new MediaInfo(jSONObject3);
            n5 |= 2;
            if (jSONObject3.has("metadata")) {
                n5 |= 4;
            }
        }
        if (jSONObject.has("currentItemId") && this.zzZE != (n3 = jSONObject.getInt("currentItemId"))) {
            this.zzZE = n3;
            n5 |= 2;
        }
        if (this.zzZO != (n2 = jSONObject.optInt("preloadedItemId", 0))) {
            this.zzZO = n2;
            n5 |= 0x10;
        }
        if (this.zzZN != (n4 = jSONObject.optInt("loadingItemId", 0))) {
            this.zzZN = n4;
            n5 |= 2;
        }
        if (!this.zzi(this.zzZH, this.zzZN)) {
            if (this.zzZP.zzg(jSONObject)) {
                n5 |= 8;
            }
        } else {
            this.zzZE = 0;
            this.zzZN = 0;
            this.zzZO = 0;
            if (this.zzZP.getItemCount() > 0) {
                this.zzZP.clear();
                n5 |= 8;
            }
        }
        return n5;
    }

    private boolean zzi(int n, int n2) {
        return n == 1 && n2 == 0;
    }

    private class zza {
        private int zzZQ = 0;
        private List<MediaQueueItem> zzZR = new ArrayList<MediaQueueItem>();
        private SparseArray<Integer> zzZS = new SparseArray();

        zza() {
        }

        private boolean zzg(JSONObject jSONObject) throws JSONException {
            int n;
            String string2;
            boolean bl = false;
            if (jSONObject.has("repeatMode")) {
                String string3;
                int n2 = this.zzZQ;
                string2 = string3 = jSONObject.getString("repeatMode");
                n = -1;
                switch (string2.hashCode()) {
                    case 1645952171: {
                        if (!string2.equals("REPEAT_OFF")) break;
                        n = 0;
                        break;
                    }
                    case 1645938909: {
                        if (!string2.equals("REPEAT_ALL")) break;
                        n = 1;
                        break;
                    }
                    case -962896020: {
                        if (!string2.equals("REPEAT_SINGLE")) break;
                        n = 2;
                        break;
                    }
                    case -1118317585: {
                        if (!string2.equals("REPEAT_ALL_AND_SHUFFLE")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    case 1: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                    }
                }
                if (this.zzZQ != n2) {
                    this.zzZQ = n2;
                    bl = true;
                }
            }
            if (jSONObject.has("items")) {
                JSONArray jSONArray = jSONObject.getJSONArray("items");
                int n3 = jSONArray.length();
                string2 = new SparseArray();
                for (n = 0; n < n3; ++n) {
                    string2.put(n, (Object)jSONArray.getJSONObject(n).getInt("itemId"));
                }
                MediaQueueItem[] mediaQueueItemArray = new MediaQueueItem[n3];
                for (int i = 0; i < n3; ++i) {
                    Integer n4 = (Integer)string2.get(i);
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    MediaQueueItem mediaQueueItem = this.zzbb(n4);
                    if (mediaQueueItem != null) {
                        bl |= mediaQueueItem.zzg(jSONObject2);
                        mediaQueueItemArray[i] = mediaQueueItem;
                        if (i == this.zzbd(n4)) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    if (n4 == MediaStatus.this.zzZE) {
                        mediaQueueItemArray[i] = new MediaQueueItem.Builder(MediaStatus.this.zzZo).build();
                        mediaQueueItemArray[i].zzg(jSONObject2);
                        continue;
                    }
                    mediaQueueItemArray[i] = new MediaQueueItem(jSONObject2);
                }
                if (this.zzZR.size() != n3) {
                    bl = true;
                }
                this.zza(mediaQueueItemArray);
            }
            return bl;
        }

        public int getRepeatMode() {
            return this.zzZQ;
        }

        public List<MediaQueueItem> zznx() {
            return Collections.unmodifiableList(this.zzZR);
        }

        public int getItemCount() {
            return this.zzZR.size();
        }

        public MediaQueueItem zzbb(int n) {
            Integer n2 = (Integer)this.zzZS.get(n);
            return n2 == null ? null : this.zzZR.get(n2);
        }

        public MediaQueueItem zzbc(int n) {
            if (n < 0 || n >= this.zzZR.size()) {
                return null;
            }
            return this.zzZR.get(n);
        }

        private Integer zzbd(int n) {
            return (Integer)this.zzZS.get(n);
        }

        private void zza(MediaQueueItem[] mediaQueueItemArray) {
            this.zzZR.clear();
            this.zzZS.clear();
            for (int i = 0; i < mediaQueueItemArray.length; ++i) {
                MediaQueueItem mediaQueueItem = mediaQueueItemArray[i];
                this.zzZR.add(mediaQueueItem);
                this.zzZS.put(mediaQueueItem.getItemId(), (Object)i);
            }
        }

        private void clear() {
            this.zzZQ = 0;
            this.zzZR.clear();
            this.zzZS.clear();
        }
    }
}

