/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzm;
import com.google.android.gms.cast.internal.zzn;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlx;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object zzpK = new Object();
    private final zzm zzZX;
    private final zza zzZY = new zza();
    private OnPreloadStatusUpdatedListener zzZZ;
    private OnQueueStatusUpdatedListener zzaaa;
    private OnMetadataUpdatedListener zzaab;
    private OnStatusUpdatedListener zzaac;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_CANCELED = 2101;
    public static final int STATUS_TIMED_OUT = 2102;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaPlayer() {
        this.zzZX = new zzm(null){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }

            @Override
            protected void onQueueStatusUpdated() {
                RemoteMediaPlayer.this.onQueueStatusUpdated();
            }

            @Override
            protected void onPreloadStatusUpdated() {
                RemoteMediaPlayer.this.onPreloadStatusUpdated();
            }
        };
        this.zzZX.zza(this.zzZY);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition, JSONObject customData) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null, customData);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final long[] activeTrackIds, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, mediaInfo, autoplay, playPosition, activeTrackIds, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zzb(this.zzaaF, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zzc(this.zzaaF, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, volume, customData);
                    }
                    catch (IOException | IllegalArgumentException | IllegalStateException exception) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, muteState, customData);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final GoogleApiClient apiClient, final long[] trackIds) {
        if (trackIds == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, trackIds);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final GoogleApiClient apiClient, final TextTrackStyle trackStyle) {
        if (trackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, trackStyle);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(GoogleApiClient apiClient, MediaQueueItem[] items, int startIndex, int repeatMode, JSONObject customData) throws IllegalArgumentException {
        return this.queueLoad(apiClient, items, startIndex, repeatMode, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueLoad(final GoogleApiClient apiClient, final MediaQueueItem[] items, final int startIndex, final int repeatMode, final long playPosition, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, items, startIndex, repeatMode, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToInsert, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, itemsToInsert, insertBeforeItemId, 0, -1, -1L, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(GoogleApiClient apiClient, MediaQueueItem item, JSONObject customData) throws IllegalArgumentException {
        return this.queueInsertItems(apiClient, new MediaQueueItem[]{item}, 0, customData);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(GoogleApiClient apiClient, MediaQueueItem item, int insertBeforeItemId, JSONObject customData) {
        return this.queueInsertAndPlayItem(apiClient, item, insertBeforeItemId, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final GoogleApiClient apiClient, final MediaQueueItem item, final int insertBeforeItemId, final long playPosition, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, new MediaQueueItem[]{item}, insertBeforeItemId, 0, 0, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final GoogleApiClient apiClient, final MediaQueueItem[] itemsToUpdate, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, 0, -1L, itemsToUpdate, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final GoogleApiClient apiClient, final int[] itemIdsToRemove, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, itemIdsToRemove, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final GoogleApiClient apiClient, final int[] itemIdsToReorder, final int insertBeforeItemId, final JSONObject customData) throws IllegalArgumentException {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, itemIdsToReorder, insertBeforeItemId, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, 0, -1L, null, -1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, 0, -1L, null, 1, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final GoogleApiClient apiClient, final int repeatMode, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, 0, -1L, null, 0, (Integer)repeatMode, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final GoogleApiClient apiClient, final int itemId, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbf(itemId) == -1) {
                        this.zzb(this.zzq(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, new int[]{itemId}, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(GoogleApiClient apiClient, int itemId, JSONObject customData) {
        return this.queueJumpToItem(apiClient, itemId, -1L, customData);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final GoogleApiClient apiClient, final int itemId, final long playPosition, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    if (RemoteMediaPlayer.this.zzbf(itemId) == -1) {
                        this.zzb(this.zzq(new Status(0)));
                        return;
                    }
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, itemId, playPosition, null, 0, null, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final GoogleApiClient apiClient, final int itemId, final int newIndex, final JSONObject customData) {
        return apiClient.zzb((zzlx.zza)new zzb(apiClient){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void zza(zze zze2) {
                Object object = RemoteMediaPlayer.this.zzpK;
                synchronized (object) {
                    int n = RemoteMediaPlayer.this.zzbf(itemId);
                    if (n == -1) {
                        this.zzb(this.zzq(new Status(0)));
                        return;
                    }
                    if (newIndex < 0) {
                        this.zzb(this.zzq(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", newIndex))));
                        return;
                    }
                    if (n == newIndex) {
                        this.zzb(this.zzq(new Status(0)));
                        return;
                    }
                    int n2 = newIndex > n ? newIndex + 1 : newIndex;
                    MediaQueueItem mediaQueueItem = RemoteMediaPlayer.this.getMediaStatus().getQueueItem(n2);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    RemoteMediaPlayer.this.zzZY.zzb(apiClient);
                    try {
                        RemoteMediaPlayer.this.zzZX.zza(this.zzaaF, new int[]{itemId}, n3, customData);
                    }
                    catch (IOException iOException) {
                        this.zzb(this.zzq(new Status(2100)));
                    }
                    finally {
                        RemoteMediaPlayer.this.zzZY.zzb(null);
                    }
                }
            }
        });
    }

    private int zzbf(int n) {
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzZX.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzZX.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzZX.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzpK;
        synchronized (object) {
            return this.zzZX.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.zzaac = listener;
    }

    private void onStatusUpdated() {
        if (this.zzaac != null) {
            this.zzaac.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.zzaab = listener;
    }

    private void onMetadataUpdated() {
        if (this.zzaab != null) {
            this.zzaab.onMetadataUpdated();
        }
    }

    public void setOnQueueStatusUpdatedListener(OnQueueStatusUpdatedListener listener) {
        this.zzaaa = listener;
    }

    private void onQueueStatusUpdated() {
        if (this.zzaaa != null) {
            this.zzaaa.onQueueStatusUpdated();
        }
    }

    public void setOnPreloadStatusUpdatedListener(OnPreloadStatusUpdatedListener listener) {
        this.zzZZ = listener;
    }

    private void onPreloadStatusUpdated() {
        if (this.zzZZ != null) {
            this.zzZZ.onPreloadStatusUpdated();
        }
    }

    public String getNamespace() {
        return this.zzZX.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.zzZX.zzbZ(message);
    }

    private static abstract class zzb
    extends com.google.android.gms.cast.internal.zzb<MediaChannelResult> {
        zzo zzaaF = new zzo(){

            @Override
            public void zzy(long l) {
                zzb.this.zzb(zzb.this.zzq(new Status(2103)));
            }

            @Override
            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzq(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzq(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzTA;
        private final JSONObject zzZn;

        zzc(Status status, JSONObject jSONObject) {
            this.zzTA = status;
            this.zzZn = jSONObject;
        }

        public Status getStatus() {
            return this.zzTA;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzZn;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$zza
    implements zzn {
        private GoogleApiClient zzaaB;
        private long zzaaC = 0L;

        public void zzb(GoogleApiClient googleApiClient) {
            this.zzaaB = googleApiClient;
        }

        @Override
        public long zzny() {
            return ++this.zzaaC;
        }

        @Override
        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzaaB == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.zzaaB, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzaaD;

            zza(long l) {
                this.zzaaD = l;
            }

            public void zzp(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.zzZX.zzb(this.zzaaD, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzp((Status)x0);
            }
        }
    }

    public static interface OnPreloadStatusUpdatedListener {
        public void onPreloadStatusUpdated();
    }

    public static interface OnQueueStatusUpdatedListener {
        public void onQueueStatusUpdated();
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

