/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zzne;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzaco;
    private int zzacp;
    private int zzxO;
    private int zzacq;
    private int zzacr;
    private int zzacs;
    private int zzact;
    private int zzacu;
    private String zzacv;
    private int zzacw;
    private int zzacx;
    private JSONObject zzaaU;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzaco = fontScale;
    }

    public float getFontScale() {
        return this.zzaco;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzacp = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzacp;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzxO = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzxO;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzacq = edgeType;
    }

    public int getEdgeType() {
        return this.zzacq;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzacr = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzacr;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzacs = windowType;
    }

    public int getWindowType() {
        return this.zzacs;
    }

    public void setWindowColor(int windowColor) {
        this.zzact = windowColor;
    }

    public int getWindowColor() {
        return this.zzact;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzacu = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzacu;
    }

    public void setFontFamily(String fontFamily) {
        this.zzacv = fontFamily;
    }

    public String getFontFamily() {
        return this.zzacv;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzacw = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzacw;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzacx = fontStyle;
    }

    public int getFontStyle() {
        return this.zzacx;
    }

    public void setCustomData(JSONObject customData) {
        this.zzaaU = customData;
    }

    public JSONObject getCustomData() {
        return this.zzaaU;
    }

    private void clear() {
        this.zzaco = 1.0f;
        this.zzacp = 0;
        this.zzxO = 0;
        this.zzacq = -1;
        this.zzacr = 0;
        this.zzacs = -1;
        this.zzact = 0;
        this.zzacu = 0;
        this.zzacv = null;
        this.zzacw = -1;
        this.zzacx = -1;
        this.zzaaU = null;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzne.zzsk()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzg(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.zzaco = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzacp = this.zzcd(jSONObject.optString("foregroundColor"));
        this.zzxO = this.zzcd(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.zzacq = 0;
            } else if ("OUTLINE".equals(string)) {
                this.zzacq = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.zzacq = 2;
            } else if ("RAISED".equals(string)) {
                this.zzacq = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.zzacq = 4;
            }
        }
        this.zzacr = this.zzcd(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.zzacs = 0;
            } else if ("NORMAL".equals(string)) {
                this.zzacs = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.zzacs = 2;
            }
        }
        this.zzact = this.zzcd(jSONObject.optString("windowColor"));
        if (this.zzacs == 2) {
            this.zzacu = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzacv = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.zzacw = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.zzacw = 1;
            } else if ("SERIF".equals(string)) {
                this.zzacw = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.zzacw = 3;
            } else if ("CASUAL".equals(string)) {
                this.zzacw = 4;
            } else if ("CURSIVE".equals(string)) {
                this.zzacw = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.zzacw = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.zzacx = 0;
            } else if ("BOLD".equals(string)) {
                this.zzacx = 1;
            } else if ("ITALIC".equals(string)) {
                this.zzacx = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.zzacx = 3;
            }
        }
        this.zzaaU = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzaco);
            if (this.zzacp != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzL(this.zzacp));
            }
            if (this.zzxO != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzL(this.zzxO));
            }
            switch (this.zzacq) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzacr != 0) {
                jSONObject.put("edgeColor", (Object)this.zzL(this.zzacr));
            }
            switch (this.zzacs) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzact != 0) {
                jSONObject.put("windowColor", (Object)this.zzL(this.zzact));
            }
            if (this.zzacs == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzacu);
            }
            if (this.zzacv != null) {
                jSONObject.put("fontFamily", (Object)this.zzacv);
            }
            switch (this.zzacw) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzacx) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzaaU != null) {
                jSONObject.put("customData", (Object)this.zzaaU);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzL(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzcd(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                int n4 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzaaU == null != (textTrackStyle.zzaaU == null)) {
            return false;
        }
        if (this.zzaaU != null && textTrackStyle.zzaaU != null && !zznb.zze((Object)this.zzaaU, (Object)textTrackStyle.zzaaU)) {
            return false;
        }
        return this.zzaco == textTrackStyle.zzaco && this.zzacp == textTrackStyle.zzacp && this.zzxO == textTrackStyle.zzxO && this.zzacq == textTrackStyle.zzacq && this.zzacr == textTrackStyle.zzacr && this.zzacs == textTrackStyle.zzacs && this.zzacu == textTrackStyle.zzacu && zzf.zza(this.zzacv, textTrackStyle.zzacv) && this.zzacw == textTrackStyle.zzacw && this.zzacx == textTrackStyle.zzacx;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzaco), this.zzacp, this.zzxO, this.zzacq, this.zzacr, this.zzacs, this.zzact, this.zzacu, this.zzacv, this.zzacw, this.zzacx, this.zzaaU});
    }
}

