/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlu;

public class zzlq
implements CastRemoteDisplayApi {
    private static final zzl zzaaf = new zzl("CastRemoteDisplayApiImpl");
    private Api.zzc<zzlr> zzaeE;
    private VirtualDisplay zzaeF;
    private final zzlu zzaeG = new zzlu.zza(){

        @Override
        public void zzbp(int n) {
            zzaaf.zzb("onRemoteDisplayEnded", new Object[0]);
            zzlq.this.zzoB();
        }
    };

    public zzlq(Api.zzc<zzlr> zzc2) {
        this.zzaeE = zzc2;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient apiClient, final String appId) {
        zzaaf.zzb("startRemoteDisplay", new Object[0]);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzlr zzlr2) throws RemoteException {
                zzlr2.zza(new zzb.zza(zzlr2), zzlq.this.zzaeG, appId);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient apiClient) {
        zzaaf.zzb("stopRemoteDisplay", new Object[0]);
        return apiClient.zzb((zza.zza)new zzb(apiClient){

            protected void zza(zzlr zzlr2) throws RemoteException {
                zzlr2.zza(new zzb.zzb());
            }
        });
    }

    @TargetApi(value=19)
    private void zzoB() {
        if (this.zzaeF != null) {
            Display display = this.zzaeF.getDisplay();
            if (display != null) {
                zzaaf.zzb("releasing virtual display: " + this.zzaeF.getDisplay().getDisplayId(), new Object[0]);
            }
            this.zzaeF.release();
            this.zzaeF = null;
        }
    }

    private abstract class com.google.android.gms.internal.zzlq$zzb
    extends zza.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzlr> {
        public com.google.android.gms.internal.zzlq$zzb(GoogleApiClient googleApiClient) {
            super(zzlq.this.zzaeE, googleApiClient);
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzt(Status status) {
            return new zzc(status);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzt(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzlq$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzaaf.zzb("onDisconnected", new Object[0]);
                zzlq.this.zzoB();
                zzb.this.zza(new zzc(Status.zzagC));
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzaaf.zzb("onError: %d", statusCode);
                zzlq.this.zzoB();
                zzb.this.zza(new zzc(Status.zzagE));
            }
        }

        @TargetApi(value=19)
        protected final class zza
        extends com.google.android.gms.internal.zzlq$zza {
            private final zzlr zzaeJ;

            public zza(zzlr zzlr2) {
                this.zzaeJ = zzlr2;
            }

            private int zzj(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzaaf.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzaeJ.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzaaf.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzagE));
                    return;
                }
                zzlq.this.zzoB();
                int n3 = this.zzj(n, n2);
                zzlq.this.zzaeF = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzlq.this.zzaeF == null) {
                    zzaaf.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzagE));
                    return;
                }
                Display display = zzlq.this.zzaeF.getDisplay();
                if (display == null) {
                    zzaaf.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzagE));
                    return;
                }
                try {
                    this.zzaeJ.zza(this, zzlq.this.zzaeF.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzaaf.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzagE));
                }
            }

            @Override
            public void zzoD() {
                zzaaf.zzb("onConnectedWithDisplay", new Object[0]);
                Display display = zzlq.this.zzaeF.getDisplay();
                if (display != null) {
                    zzb.this.zza(new zzc(display));
                } else {
                    zzaaf.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zza(new zzc(Status.zzagE));
                }
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzaaf.zzb("onError: %d", statusCode);
                zzlq.this.zzoB();
                zzb.this.zza(new zzc(Status.zzagE));
            }
        }
    }

    private abstract class zza
    extends zzls.zza {
        private zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int statusCode) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zzoD() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzUX;
        private final Display zzaar;

        public zzc(Display display) {
            this.zzUX = Status.zzagC;
            this.zzaar = display;
        }

        public zzc(Status status) {
            this.zzUX = status;
            this.zzaar = null;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzaar;
        }
    }
}

