/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzp;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaTrack {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_TEXT = 1;
    public static final int TYPE_AUDIO = 2;
    public static final int TYPE_VIDEO = 3;
    public static final int SUBTYPE_UNKNOWN = -1;
    public static final int SUBTYPE_NONE = 0;
    public static final int SUBTYPE_SUBTITLES = 1;
    public static final int SUBTYPE_CAPTIONS = 2;
    public static final int SUBTYPE_DESCRIPTIONS = 3;
    public static final int SUBTYPE_CHAPTERS = 4;
    public static final int SUBTYPE_METADATA = 5;
    private long zzaaQ;
    private int zzagd;
    private String zzafp;
    private String zzafr;
    private String mName;
    private String zzVp;
    private int zzage;
    private JSONObject zzafw;

    MediaTrack(JSONObject jSONObject) throws JSONException {
        this.zzi(jSONObject);
    }

    MediaTrack(long l, int n) throws IllegalArgumentException {
        this.clear();
        this.zzaaQ = l;
        if (n <= 0 || n > 3) {
            throw new IllegalArgumentException(new StringBuilder(24).append("invalid type ").append(n).toString());
        }
        this.zzagd = n;
    }

    public long getId() {
        return this.zzaaQ;
    }

    public int getType() {
        return this.zzagd;
    }

    public String getContentId() {
        return this.zzafp;
    }

    public void setContentId(String string2) {
        this.zzafp = string2;
    }

    public String getContentType() {
        return this.zzafr;
    }

    public void setContentType(String string2) {
        this.zzafr = string2;
    }

    public String getName() {
        return this.mName;
    }

    void setName(String string2) {
        this.mName = string2;
    }

    public String getLanguage() {
        return this.zzVp;
    }

    void setLanguage(String string2) {
        this.zzVp = string2;
    }

    public int getSubtype() {
        return this.zzage;
    }

    void zzbl(int n) throws IllegalArgumentException {
        if (n <= -1 || n > 5) {
            throw new IllegalArgumentException(new StringBuilder(27).append("invalid subtype ").append(n).toString());
        }
        if (n != 0 && this.zzagd != 1) {
            throw new IllegalArgumentException("subtypes are only valid for text tracks");
        }
        this.zzage = n;
    }

    public JSONObject getCustomData() {
        return this.zzafw;
    }

    void setCustomData(JSONObject jSONObject) {
        this.zzafw = jSONObject;
    }

    private void clear() {
        this.zzaaQ = 0L;
        this.zzagd = 0;
        this.zzafp = null;
        this.mName = null;
        this.zzVp = null;
        this.zzage = -1;
        this.zzafw = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void zzi(JSONObject jSONObject) throws JSONException {
        block12: {
            block13: {
                String string2;
                block16: {
                    block15: {
                        block14: {
                            this.clear();
                            this.zzaaQ = jSONObject.getLong("trackId");
                            string2 = jSONObject.getString("type");
                            if ("TEXT".equals(string2)) {
                                this.zzagd = 1;
                            } else if ("AUDIO".equals(string2)) {
                                this.zzagd = 2;
                            } else if ("VIDEO".equals(string2)) {
                                this.zzagd = 3;
                            } else {
                                String string3;
                                String string4 = String.valueOf(string2);
                                if (string4.length() != 0) {
                                    string3 = "invalid type: ".concat(string4);
                                    throw new JSONException(string3);
                                }
                                string3 = new String("invalid type: ");
                                throw new JSONException(string3);
                            }
                            this.zzafp = jSONObject.optString("trackContentId", null);
                            this.zzafr = jSONObject.optString("trackContentType", null);
                            this.mName = jSONObject.optString("name", null);
                            this.zzVp = jSONObject.optString("language", null);
                            if (!jSONObject.has("subtype")) break block13;
                            string2 = jSONObject.getString("subtype");
                            if (!"SUBTITLES".equals(string2)) break block14;
                            this.zzage = 1;
                            break block12;
                        }
                        if (!"CAPTIONS".equals(string2)) break block15;
                        this.zzage = 2;
                        break block12;
                    }
                    if (!"DESCRIPTIONS".equals(string2)) break block16;
                    this.zzage = 3;
                    break block12;
                }
                if ("CHAPTERS".equals(string2)) {
                    this.zzage = 4;
                    break block12;
                } else if ("METADATA".equals(string2)) {
                    this.zzage = 5;
                    break block12;
                } else {
                    String string5;
                    String string6 = String.valueOf(string2);
                    if (string6.length() != 0) {
                        string5 = "invalid subtype: ".concat(string6);
                        throw new JSONException(string5);
                    }
                    string5 = new String("invalid subtype: ");
                    throw new JSONException(string5);
                }
            }
            this.zzage = 0;
        }
        this.zzafw = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("trackId", this.zzaaQ);
            switch (this.zzagd) {
                case 1: {
                    jSONObject.put("type", (Object)"TEXT");
                    break;
                }
                case 2: {
                    jSONObject.put("type", (Object)"AUDIO");
                    break;
                }
                case 3: {
                    jSONObject.put("type", (Object)"VIDEO");
                    break;
                }
            }
            if (this.zzafp != null) {
                jSONObject.put("trackContentId", (Object)this.zzafp);
            }
            if (this.zzafr != null) {
                jSONObject.put("trackContentType", (Object)this.zzafr);
            }
            if (this.mName != null) {
                jSONObject.put("name", (Object)this.mName);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzVp)) {
                jSONObject.put("language", (Object)this.zzVp);
            }
            switch (this.zzage) {
                case 1: {
                    jSONObject.put("subtype", (Object)"SUBTITLES");
                    break;
                }
                case 2: {
                    jSONObject.put("subtype", (Object)"CAPTIONS");
                    break;
                }
                case 3: {
                    jSONObject.put("subtype", (Object)"DESCRIPTIONS");
                    break;
                }
                case 4: {
                    jSONObject.put("subtype", (Object)"CHAPTERS");
                    break;
                }
                case 5: {
                    jSONObject.put("subtype", (Object)"METADATA");
                    break;
                }
            }
            if (this.zzafw != null) {
                jSONObject.put("customData", (Object)this.zzafw);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MediaTrack)) {
            return false;
        }
        MediaTrack mediaTrack = (MediaTrack)object;
        if (this.zzafw == null != (mediaTrack.zzafw == null)) {
            return false;
        }
        if (this.zzafw != null && mediaTrack.zzafw != null && !zzp.zzf((Object)this.zzafw, (Object)mediaTrack.zzafw)) {
            return false;
        }
        return this.zzaaQ == mediaTrack.zzaaQ && this.zzagd == mediaTrack.zzagd && zzf.zza(this.zzafp, mediaTrack.zzafp) && zzf.zza(this.zzafr, mediaTrack.zzafr) && zzf.zza(this.mName, mediaTrack.mName) && zzf.zza(this.zzVp, mediaTrack.zzVp) && this.zzage == mediaTrack.zzage;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.zzaaQ, this.zzagd, this.zzafp, this.zzafr, this.mName, this.zzVp, this.zzage, this.zzafw});
    }

    public static class Builder {
        private final MediaTrack zzagf;

        public Builder(long l, int n) throws IllegalArgumentException {
            this.zzagf = new MediaTrack(l, n);
        }

        public Builder setContentId(String string2) {
            this.zzagf.setContentId(string2);
            return this;
        }

        public Builder setContentType(String string2) {
            this.zzagf.setContentType(string2);
            return this;
        }

        public Builder setName(String string2) {
            this.zzagf.setName(string2);
            return this;
        }

        public Builder setLanguage(String string2) {
            this.zzagf.setLanguage(string2);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.zzagf.setLanguage(zzf.zzb(locale));
            return this;
        }

        public Builder setSubtype(int n) throws IllegalArgumentException {
            this.zzagf.zzbl(n);
            return this;
        }

        public Builder setCustomData(JSONObject jSONObject) {
            this.zzagf.setCustomData(jSONObject);
            return this;
        }

        public MediaTrack build() {
            return this.zzagf;
        }
    }
}

