/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzs;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzagQ;
    private int zzagR;
    private int mBackgroundColor;
    private int zzagS;
    private int zzagT;
    private int zzagU;
    private int zzagV;
    private int zzagW;
    private String zzagX;
    private int zzagY;
    private int zzagZ;
    private JSONObject zzafw;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float f) {
        this.zzagQ = f;
    }

    public float getFontScale() {
        return this.zzagQ;
    }

    public void setForegroundColor(int n) {
        this.zzagR = n;
    }

    public int getForegroundColor() {
        return this.zzagR;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setEdgeType(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzagS = n;
    }

    public int getEdgeType() {
        return this.zzagS;
    }

    public void setEdgeColor(int n) {
        this.zzagT = n;
    }

    public int getEdgeColor() {
        return this.zzagT;
    }

    public void setWindowType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzagU = n;
    }

    public int getWindowType() {
        return this.zzagU;
    }

    public void setWindowColor(int n) {
        this.zzagV = n;
    }

    public int getWindowColor() {
        return this.zzagV;
    }

    public void setWindowCornerRadius(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzagW = n;
    }

    public int getWindowCornerRadius() {
        return this.zzagW;
    }

    public void setFontFamily(String string2) {
        this.zzagX = string2;
    }

    public String getFontFamily() {
        return this.zzagX;
    }

    public void setFontGenericFamily(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzagY = n;
    }

    public int getFontGenericFamily() {
        return this.zzagY;
    }

    public void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzagZ = n;
    }

    public int getFontStyle() {
        return this.zzagZ;
    }

    public void setCustomData(JSONObject jSONObject) {
        this.zzafw = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.zzafw;
    }

    private void clear() {
        this.zzagQ = 1.0f;
        this.zzagR = 0;
        this.mBackgroundColor = 0;
        this.zzagS = -1;
        this.zzagT = 0;
        this.zzagU = -1;
        this.zzagV = 0;
        this.zzagW = 0;
        this.zzagX = null;
        this.zzagY = -1;
        this.zzagZ = -1;
        this.zzafw = null;
    }

    @TargetApi(value=19)
    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzs.zzve()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzi(JSONObject jSONObject) throws JSONException {
        String string2;
        this.clear();
        this.zzagQ = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzagR = this.zzcA(jSONObject.optString("foregroundColor"));
        this.mBackgroundColor = this.zzcA(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.zzagS = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.zzagS = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.zzagS = 2;
            } else if ("RAISED".equals(string2)) {
                this.zzagS = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.zzagS = 4;
            }
        }
        this.zzagT = this.zzcA(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.zzagU = 0;
            } else if ("NORMAL".equals(string2)) {
                this.zzagU = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.zzagU = 2;
            }
        }
        this.zzagV = this.zzcA(jSONObject.optString("windowColor"));
        if (this.zzagU == 2) {
            this.zzagW = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzagX = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.zzagY = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.zzagY = 1;
            } else if ("SERIF".equals(string2)) {
                this.zzagY = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.zzagY = 3;
            } else if ("CASUAL".equals(string2)) {
                this.zzagY = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.zzagY = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.zzagY = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.zzagZ = 0;
            } else if ("BOLD".equals(string2)) {
                this.zzagZ = 1;
            } else if ("ITALIC".equals(string2)) {
                this.zzagZ = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.zzagZ = 3;
            }
        }
        this.zzafw = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzagQ);
            if (this.zzagR != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzS(this.zzagR));
            }
            if (this.mBackgroundColor != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzS(this.mBackgroundColor));
            }
            switch (this.zzagS) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzagT != 0) {
                jSONObject.put("edgeColor", (Object)this.zzS(this.zzagT));
            }
            switch (this.zzagU) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzagV != 0) {
                jSONObject.put("windowColor", (Object)this.zzS(this.zzagV));
            }
            if (this.zzagU == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzagW);
            }
            if (this.zzagX != null) {
                jSONObject.put("fontFamily", (Object)this.zzagX);
            }
            switch (this.zzagY) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzagZ) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzafw != null) {
                jSONObject.put("customData", (Object)this.zzafw);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzS(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzcA(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string2.substring(1, 3), 16);
                int n2 = Integer.parseInt(string2.substring(3, 5), 16);
                int n3 = Integer.parseInt(string2.substring(5, 7), 16);
                int n4 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)object;
        if (this.zzafw == null != (textTrackStyle.zzafw == null)) {
            return false;
        }
        if (this.zzafw != null && textTrackStyle.zzafw != null && !zzp.zzf((Object)this.zzafw, (Object)textTrackStyle.zzafw)) {
            return false;
        }
        return this.zzagQ == textTrackStyle.zzagQ && this.zzagR == textTrackStyle.zzagR && this.mBackgroundColor == textTrackStyle.mBackgroundColor && this.zzagS == textTrackStyle.zzagS && this.zzagT == textTrackStyle.zzagT && this.zzagU == textTrackStyle.zzagU && this.zzagW == textTrackStyle.zzagW && zzf.zza(this.zzagX, textTrackStyle.zzagX) && this.zzagY == textTrackStyle.zzagY && this.zzagZ == textTrackStyle.zzagZ;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{Float.valueOf(this.zzagQ), this.zzagR, this.mBackgroundColor, this.zzagS, this.zzagT, this.zzagU, this.zzagV, this.zzagW, this.zzagX, this.zzagY, this.zzagZ, this.zzafw});
    }
}

