/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.JoinOptions;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.zzb;
import com.google.android.gms.cast.internal.zze;
import com.google.android.gms.cast.internal.zzh;
import com.google.android.gms.cast.internal.zzk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.internal.zznt;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final int ACTIVE_INPUT_STATE_UNKNOWN = -1;
    public static final int ACTIVE_INPUT_STATE_NO = 0;
    public static final int ACTIVE_INPUT_STATE_YES = 1;
    public static final int STANDBY_STATE_UNKNOWN = -1;
    public static final int STANDBY_STATE_NO = 0;
    public static final int STANDBY_STATE_YES = 1;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.zza<zze, CastOptions> zzaaA = new Api.zza<zze, CastOptions>(){

        public zze zza(Context context, Looper looper, zzg zzg2, CastOptions castOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            zzaa.zzb((Object)castOptions, (Object)"Setting the API options is required.");
            return new zze(context, looper, zzg2, castOptions.zzaep, castOptions.zzaer, castOptions.zzaeq, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api<CastOptions> API = new Api("Cast.API", zzaaA, zzk.zzaiF);
    public static final CastApi CastApi = new CastApi.zza();

    private Cast() {
    }

    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        @Deprecated
        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, LaunchOptions var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public int getActiveInputState(GoogleApiClient var1) throws IllegalStateException;

        public int getStandbyState(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalArgumentException;

        public static final class zza
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient googleApiClient) throws IOException, IllegalStateException {
                try {
                    ((zze)googleApiClient.zza(zzk.zzaiF)).zzqt();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient googleApiClient, final String string, final String string2) {
                return googleApiClient.zzd((zznt.zza)new zzh(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(string, string2, (zznt.zzb<Status>)this);
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzd((zznt.zza)new com.google.android.gms.cast.Cast$zza(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(string, false, (zznt.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, final String string, final LaunchOptions launchOptions) {
                return googleApiClient.zzd((zznt.zza)new com.google.android.gms.cast.Cast$zza(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(string, launchOptions, (zznt.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            @Deprecated
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient googleApiClient, String string, boolean bl) {
                LaunchOptions launchOptions = new LaunchOptions.Builder().setRelaunchIfRunning(bl).build();
                return this.launchApplication(googleApiClient, string, launchOptions);
            }

            public PendingResult<ApplicationConnectionResult> zza(GoogleApiClient googleApiClient, final String string, final String string2, final JoinOptions joinOptions) {
                return googleApiClient.zzd((zznt.zza)new com.google.android.gms.cast.Cast$zza(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza(string, string2, joinOptions, (zznt.zzb<ApplicationConnectionResult>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string, String string2) {
                return this.zza(googleApiClient, string, string2, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient, String string) {
                return this.zza(googleApiClient, string, null, null);
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient googleApiClient) {
                return this.zza(googleApiClient, null, null, null);
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzd((zznt.zza)new zzh(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zzb((zznt.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient) {
                return googleApiClient.zzd((zznt.zza)new zzh(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        try {
                            zze2.zza("", (zznt.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient googleApiClient, final String string) {
                return googleApiClient.zzd((zznt.zza)new zzh(googleApiClient){

                    @Override
                    public void zza(zze zze2) throws RemoteException {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            this.zze(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            zze2.zza(string, (zznt.zzb<Status>)this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.zzbq(2001);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient googleApiClient, double d) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    ((zze)googleApiClient.zza(zzk.zzaiF)).zzf(d);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).zzqu();
            }

            @Override
            public void setMute(GoogleApiClient googleApiClient, boolean bl) throws IOException, IllegalStateException {
                try {
                    ((zze)googleApiClient.zza(zzk.zzaiF)).zzaf(bl);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).isMute();
            }

            @Override
            public int getActiveInputState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).zzqv();
            }

            @Override
            public int getStandbyState(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).zzqw();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient googleApiClient) throws IllegalStateException {
                return ((zze)googleApiClient.zza(zzk.zzaiF)).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string, MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
                try {
                    ((zze)googleApiClient.zza(zzk.zzaiF)).zza(string, messageReceivedCallback);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient googleApiClient, String string) throws IOException, IllegalArgumentException {
                try {
                    ((zze)googleApiClient.zza(zzk.zzaiF)).zzcD(string);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    static abstract class zza
    extends zzb<ApplicationConnectionResult> {
        public zza(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public ApplicationConnectionResult zzn(final Status status) {
            return new ApplicationConnectionResult(){

                public Status getStatus() {
                    return status;
                }

                @Override
                public boolean getWasLaunched() {
                    return false;
                }

                @Override
                public String getSessionId() {
                    return null;
                }

                @Override
                public String getApplicationStatus() {
                    return null;
                }

                @Override
                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        public void zza(zze zze2) throws RemoteException {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzn(status);
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements Api.ApiOptions.HasOptions {
        final CastDevice zzaep;
        final Listener zzaeq;
        private final int zzaer;

        private CastOptions(Builder builder) {
            this.zzaep = builder.zzaes;
            this.zzaeq = builder.zzaet;
            this.zzaer = builder.zzaeu;
        }

        @Deprecated
        public static Builder builder(CastDevice castDevice, Listener listener) {
            return new Builder(castDevice, listener);
        }

        public static final class Builder {
            CastDevice zzaes;
            Listener zzaet;
            private int zzaeu;

            public Builder(CastDevice castDevice, Listener listener) {
                zzaa.zzb((Object)((Object)castDevice), (Object)"CastDevice parameter cannot be null");
                zzaa.zzb((Object)listener, (Object)"CastListener parameter cannot be null");
                this.zzaes = castDevice;
                this.zzaet = listener;
                this.zzaeu = 0;
            }

            public Builder setVerboseLoggingEnabled(boolean bl) {
                this.zzaeu = bl ? (this.zzaeu |= 1) : (this.zzaeu &= 0xFFFFFFFE);
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
        }

        public void onApplicationDisconnected(int n) {
        }

        public void onActiveInputStateChanged(int n) {
        }

        public void onStandbyStateChanged(int n) {
        }

        public void onVolumeChanged() {
        }
    }
}

