/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.gms.cloudmessaging.zzf;
import com.google.android.gms.cloudmessaging.zzg;
import com.google.android.gms.cloudmessaging.zzh;
import com.google.android.gms.cloudmessaging.zzi;
import com.google.android.gms.cloudmessaging.zzj;
import com.google.android.gms.cloudmessaging.zzl;
import com.google.android.gms.cloudmessaging.zzn;
import com.google.android.gms.cloudmessaging.zzp;
import com.google.android.gms.cloudmessaging.zzq;
import com.google.android.gms.cloudmessaging.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class zzm
implements ServiceConnection {
    @GuardedBy(value="this")
    int zza = 0;
    final Messenger zzb;
    zzn zzc;
    @GuardedBy(value="this")
    final Queue<zzp<?>> zzd;
    @GuardedBy(value="this")
    final SparseArray<zzp<?>> zze;
    final /* synthetic */ zzs zzf;

    /* synthetic */ zzm(zzs sparseArray, zzl object) {
        this.zzf = sparseArray;
        Looper looper = Looper.getMainLooper();
        zzf zzf2 = new zzf(this);
        super(looper, zzf2);
        super((Handler)object);
        this.zzb = sparseArray;
        sparseArray = new ArrayDeque();
        this.zzd = sparseArray;
        this.zze = sparseArray = new SparseArray();
    }

    final synchronized void zza(int n, @Nullable String string) {
        this.zzb(n, string, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    final synchronized void zzb(int n, @Nullable String string, @Nullable Throwable throwable) {
        Object object;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            object = String.valueOf(string);
            String string2 = "Disconnected: ";
            object = ((String)object).length() != 0 ? string2.concat((String)object) : new String(string2);
            Log.d((String)"MessengerIpcClient", (String)object);
        }
        switch (((zzm)object2).zza) {
            default: {
                return;
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                ((zzm)object2).zza = 4;
                ConnectionTracker.getInstance().unbindService(zzs.zza(((zzm)object2).zzf), (ServiceConnection)object2);
                object = new zzq(n, string, throwable);
                Iterator iterator = ((zzm)object2).zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzp)iterator.next()).zzc((zzq)object);
                }
                ((zzm)object2).zzd.clear();
                int n2 = 0;
                while (true) {
                    if (n2 >= ((zzm)object2).zze.size()) {
                        ((zzm)object2).zze.clear();
                        return;
                    }
                    ((zzp)((zzm)object2).zze.valueAt(n2)).zzc((zzq)object);
                    ++n2;
                }
            }
            case 3: {
                ((zzm)object2).zza = 4;
                return;
            }
            case 0: 
        }
        Object object2 = new IllegalStateException();
        throw object2;
    }

    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        object = this.zzf;
        object = zzs.zze((zzs)object);
        zzj zzj2 = new zzj(this, iBinder);
        object.execute(zzj2);
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName object) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        object = this.zzf;
        object = zzs.zze((zzs)object);
        zzg zzg2 = new zzg(this);
        object.execute(zzg2);
    }

    final void zzc() {
        Object object = this.zzf;
        object = zzs.zze((zzs)object);
        zzh zzh2 = new zzh(this);
        object.execute(zzh2);
    }

    final synchronized void zzd() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
            return;
        }
    }

    final synchronized void zze(int n) {
        zzp zzp2 = (zzp)this.zze.get(n);
        if (zzp2 != null) {
            StringBuilder stringBuilder = new StringBuilder(31);
            stringBuilder.append("Timing out request: ");
            stringBuilder.append(n);
            Log.w((String)"MessengerIpcClient", (String)stringBuilder.toString());
            this.zze.remove(n);
            zzq zzq2 = new zzq(3, "Timed out waiting for response", null);
            zzp2.zzc(zzq2);
            this.zzf();
            return;
        }
    }

    final synchronized void zzf() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            ConnectionTracker.getInstance().unbindService(zzs.zza(this.zzf), (ServiceConnection)this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final synchronized boolean zzg(zzp<?> zzp2) {
        switch (this.zza) {
            default: {
                return false;
            }
            case 0: {
                this.zzd.add(zzp2);
                boolean bl = this.zza == 0;
                Preconditions.checkState((boolean)bl);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                this.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                try {
                    boolean bl2 = ConnectionTracker.getInstance().bindService(zzs.zza(this.zzf), intent, (ServiceConnection)this, 1);
                    if (!bl2) {
                        this.zza(0, "Unable to bind to service");
                        return true;
                    }
                }
                catch (SecurityException securityException) {
                    this.zzb(0, "Unable to bind to service", securityException);
                    return true;
                }
                Object object = this.zzf;
                object = zzs.zze((zzs)object);
                zzi zzi2 = new zzi(this);
                object.schedule(zzi2, 30L, TimeUnit.SECONDS);
                return true;
            }
            case 2: {
                this.zzd.add(zzp2);
                this.zzc();
                return true;
            }
            case 1: 
        }
        this.zzd.add(zzp2);
        return true;
    }
}

