/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cloudmessaging;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.google.android.gms.cloudmessaging.zzi;
import com.google.android.gms.cloudmessaging.zzj;
import com.google.android.gms.cloudmessaging.zzk;
import com.google.android.gms.cloudmessaging.zzl;
import com.google.android.gms.cloudmessaging.zzm;
import com.google.android.gms.cloudmessaging.zzo;
import com.google.android.gms.cloudmessaging.zzq;
import com.google.android.gms.cloudmessaging.zzs;
import com.google.android.gms.cloudmessaging.zzt;
import com.google.android.gms.cloudmessaging.zzv;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.cloudmessaging.zzf;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class zzp
implements ServiceConnection {
    int zza = 0;
    final Messenger zzb = new Messenger((Handler)new zzf(Looper.getMainLooper(), new zzm(this)));
    zzq zzc;
    final Queue zzd = new ArrayDeque();
    final SparseArray zze = new SparseArray();
    final /* synthetic */ zzv zzf;

    /* synthetic */ zzp(zzv zzv2, zzo zzo2) {
        this.zzf = zzv2;
    }

    final synchronized void zza(int n, @Nullable String string) {
        this.zzb(n, string, null);
    }

    final synchronized void zzb(int n, @Nullable String string, @Nullable Throwable throwable) {
        Object object;
        if (Log.isLoggable((String)"MessengerIpcClient", (int)3)) {
            object = String.valueOf(string);
            String string2 = "Disconnected: ";
            Log.d((String)"MessengerIpcClient", (String)string2.concat((String)object));
        }
        switch (this.zza) {
            default: {
                return;
            }
            case 1: 
            case 2: {
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Unbinding service");
                }
                this.zza = 4;
                object = this.zzf;
                ConnectionTracker.getInstance().unbindService(zzv.zza((zzv)object), (ServiceConnection)this);
                object = new zzt(n, string, throwable);
                Iterator iterator = this.zzd.iterator();
                while (iterator.hasNext()) {
                    ((zzs)iterator.next()).zzc((zzt)object);
                }
                this.zzd.clear();
                for (int i = 0; i < this.zze.size(); ++i) {
                    ((zzs)this.zze.valueAt(i)).zzc((zzt)object);
                }
                this.zze.clear();
                return;
            }
            case 0: {
                throw new IllegalStateException();
            }
            case 3: 
        }
        this.zza = 4;
    }

    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service connected");
        }
        zzv.zze(this.zzf).execute(new zzi(this, iBinder));
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
            Log.v((String)"MessengerIpcClient", (String)"Service disconnected");
        }
        zzv.zze(this.zzf).execute(new zzl(this));
    }

    final void zzc() {
        zzv.zze(this.zzf).execute(new zzj(this));
    }

    final synchronized void zzd() {
        if (this.zza == 1) {
            this.zza(1, "Timed out while binding");
            return;
        }
    }

    final synchronized void zze(int n) {
        zzs zzs2 = (zzs)this.zze.get(n);
        if (zzs2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Timing out request: ");
            stringBuilder.append(n);
            String string = stringBuilder.toString();
            Log.w((String)"MessengerIpcClient", (String)string);
            this.zze.remove(n);
            String string2 = "Timed out waiting for response";
            zzs2.zzc(new zzt(3, string2, null));
            this.zzf();
            return;
        }
    }

    final synchronized void zzf() {
        if (this.zza == 2 && this.zzd.isEmpty() && this.zze.size() == 0) {
            if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                Log.v((String)"MessengerIpcClient", (String)"Finished handling requests, unbinding");
            }
            this.zza = 3;
            zzv zzv2 = this.zzf;
            ConnectionTracker.getInstance().unbindService(zzv.zza(zzv2), (ServiceConnection)this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final synchronized boolean zzg(zzs zzs2) {
        switch (this.zza) {
            default: {
                return false;
            }
            case 2: {
                this.zzd.add(zzs2);
                this.zzc();
                return true;
            }
            case 0: {
                this.zzd.add(zzs2);
                boolean bl = this.zza == 0;
                Preconditions.checkState((boolean)bl);
                if (Log.isLoggable((String)"MessengerIpcClient", (int)2)) {
                    Log.v((String)"MessengerIpcClient", (String)"Starting bind to GmsCore");
                }
                this.zza = 1;
                Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
                intent.setPackage("com.google.android.gms");
                try {
                    boolean bl2 = ConnectionTracker.getInstance().bindService(zzv.zza(this.zzf), intent, (ServiceConnection)this, 1);
                    if (!bl2) {
                        this.zza(0, "Unable to bind to service");
                        return true;
                    }
                }
                catch (SecurityException securityException) {
                    this.zzb(0, "Unable to bind to service", securityException);
                    return true;
                }
                zzv.zze(this.zzf).schedule(new zzk(this), 30L, TimeUnit.SECONDS);
                return true;
            }
            case 1: 
        }
        this.zzd.add(zzs2);
        return true;
    }
}

