/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zza {
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzdxt;
    private final byte[] zzgql;
    private final ProtocolVersion zzgqm;
    private final List<Transport> zzdky;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzdxt = n;
        this.zzgql = byArray;
        try {
            this.zzgqm = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdky = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzdxt = 1;
        this.zzgql = byArray;
        this.zzgqm = protocolVersion;
        this.zzdky = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzdxt;
    }

    public byte[] getBytes() {
        return this.zzgql;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgqm;
    }

    public List<Transport> getTransports() {
        return this.zzdky;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzd.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzgqm.toString(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdky == null ? "null" : this.zzdky.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzb.encode((byte[])this.zzgql), this.zzgqm, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzgql), this.zzgqm, this.zzdky});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzgql, keyHandle.zzgql)) {
            return false;
        }
        if (!this.zzgqm.equals((Object)keyHandle.zzgqm)) {
            return false;
        }
        if (this.zzdky == null && keyHandle.zzdky == null) {
            return true;
        }
        if (this.zzdky == null || keyHandle.zzdky == null) {
            return false;
        }
        return this.zzdky.containsAll(keyHandle.zzdky) && keyHandle.zzdky.containsAll(this.zzdky);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzgql != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzgql, (int)11));
            }
            if (this.zzgqm != null) {
                jSONObject.put("version", (Object)this.zzgqm.toString());
            }
            if (this.zzdky != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdky) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

