/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgge;
    private final Double zzgqp;
    private final Uri zzgqq;
    private final byte[] zzgra;
    private final List<RegisteredKey> zzgqs;
    private final ChannelIdValue zzgqt;
    private final String zzgqu;
    private final Set<Uri> zzgqv;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzgge = n;
        this.zzgqp = d;
        this.zzgqq = uri;
        this.zzgra = byArray;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgqs = list;
        this.zzgqt = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbp.zzb((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbp.zzb((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgqv = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgqu = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgge;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqp;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqq;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgqv;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgra;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgqs;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgqt;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgqu;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzgge, (Object)signRequestParams.zzgge) && zzbf.equal((Object)this.zzgqp, (Object)signRequestParams.zzgqp) && zzbf.equal((Object)this.zzgqq, (Object)signRequestParams.zzgqq) && Arrays.equals(this.zzgra, signRequestParams.zzgra) && this.zzgqs.containsAll(signRequestParams.zzgqs) && signRequestParams.zzgqs.containsAll(this.zzgqs) && zzbf.equal((Object)((Object)this.zzgqt), (Object)((Object)signRequestParams.zzgqt)) && zzbf.equal((Object)this.zzgqu, (Object)signRequestParams.zzgqu);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgge, this.zzgqq, this.zzgqp, this.zzgqs, this.zzgqt, this.zzgqu, Arrays.hashCode(this.zzgra)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgge;
        private Double zzgqp;
        private Uri zzgqq;
        private byte[] zzgra;
        private List<RegisteredKey> zzgqs;
        private ChannelIdValue zzgqt;
        private String zzgqu;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgge = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqp = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqq = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgra = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgqs = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgqt = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgqu = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzgge, this.zzgqp, this.zzgqq, this.zzgra, this.zzgqs, this.zzgqt, this.zzgqu);
        }
    }
}

