/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzggn;
    private final Double zzgqx;
    private final Uri zzgqy;
    private final byte[] zzgri;
    private final List<RegisteredKey> zzgra;
    private final ChannelIdValue zzgrb;
    private final String zzgrc;
    private final Set<Uri> zzgrd;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzggn = n;
        this.zzgqx = d;
        this.zzgqy = uri;
        this.zzgri = byArray;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgra = list;
        this.zzgrb = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbp.zzb((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbp.zzb((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgrd = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgrc = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzggn;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqx;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqy;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgrd;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgri;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgra;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgrb;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgrc;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzggn, (Object)signRequestParams.zzggn) && zzbf.equal((Object)this.zzgqx, (Object)signRequestParams.zzgqx) && zzbf.equal((Object)this.zzgqy, (Object)signRequestParams.zzgqy) && Arrays.equals(this.zzgri, signRequestParams.zzgri) && this.zzgra.containsAll(signRequestParams.zzgra) && signRequestParams.zzgra.containsAll(this.zzgra) && zzbf.equal((Object)((Object)this.zzgrb), (Object)((Object)signRequestParams.zzgrb)) && zzbf.equal((Object)this.zzgrc, (Object)signRequestParams.zzgrc);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzggn, this.zzgqy, this.zzgqx, this.zzgra, this.zzgrb, this.zzgrc, Arrays.hashCode(this.zzgri)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzggn;
        private Double zzgqx;
        private Uri zzgqy;
        private byte[] zzgri;
        private List<RegisteredKey> zzgra;
        private ChannelIdValue zzgrb;
        private String zzgrc;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzggn = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqx = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqy = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgri = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgra = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgrb = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgrc = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzggn, this.zzgqx, this.zzgqy, this.zzgri, this.zzgra, this.zzgrb, this.zzgrc);
        }
    }
}

