/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbck {
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzdxs;
    private final byte[] zzgqu;
    private final ProtocolVersion zzgqv;
    private final List<Transport> zzdkt;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzdxs = n;
        this.zzgqu = byArray;
        try {
            this.zzgqv = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdkt = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzdxs = 1;
        this.zzgqu = byArray;
        this.zzgqv = protocolVersion;
        this.zzdkt = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzdxs;
    }

    public byte[] getBytes() {
        return this.zzgqu;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgqv;
    }

    public List<Transport> getTransports() {
        return this.zzdkt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbcn.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzgqv.toString(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdkt == null ? "null" : this.zzdkt.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzb.zzj((byte[])this.zzgqu), this.zzgqv, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzgqu), this.zzgqv, this.zzdkt});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzgqu, keyHandle.zzgqu)) {
            return false;
        }
        if (!this.zzgqv.equals((Object)keyHandle.zzgqv)) {
            return false;
        }
        if (this.zzdkt == null && keyHandle.zzdkt == null) {
            return true;
        }
        if (this.zzdkt == null || keyHandle.zzdkt == null) {
            return false;
        }
        return this.zzdkt.containsAll(keyHandle.zzdkt) && keyHandle.zzdkt.containsAll(this.zzdkt);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzgqu != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzgqu, (int)11));
            }
            if (this.zzgqv != null) {
                jSONObject.put("version", (Object)this.zzgqv.toString());
            }
            if (this.zzdkt != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdkt) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

