/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzggo;
    private final Double zzgqy;
    private final Uri zzgqz;
    private final List<RegisterRequest> zzgra;
    private final List<RegisteredKey> zzgrb;
    private final ChannelIdValue zzgrc;
    private final String zzgrd;
    private Set<Uri> zzgre;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzggo = n;
        this.zzgqy = d;
        this.zzgqz = uri;
        zzbp.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzgra = list;
        this.zzgrb = list2;
        this.zzgrc = channelIdValue;
        List<RegisteredKey> list3 = this.zzgrb;
        List<RegisterRequest> list4 = this.zzgra;
        Uri uri2 = this.zzgqz;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbck2 : list4) {
            zzbp.zzb((uri2 != null || zzbck2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbck2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbck2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbp.zzb((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgre = hashSet;
        zzbp.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgrd = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzggo;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgqy;
    }

    @Override
    public Uri getAppId() {
        return this.zzgqz;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgre;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzgra;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgrb;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgrc;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgrd;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbf.equal((Object)this.zzggo, (Object)registerRequestParams.zzggo) && zzbf.equal((Object)this.zzgqy, (Object)registerRequestParams.zzgqy) && zzbf.equal((Object)this.zzgqz, (Object)registerRequestParams.zzgqz) && zzbf.equal(this.zzgra, registerRequestParams.zzgra) && (this.zzgrb == null && registerRequestParams.zzgrb == null || this.zzgrb != null && registerRequestParams.zzgrb != null && this.zzgrb.containsAll(registerRequestParams.zzgrb) && registerRequestParams.zzgrb.containsAll(this.zzgrb)) && zzbf.equal((Object)((Object)this.zzgrc), (Object)((Object)registerRequestParams.zzgrc)) && zzbf.equal((Object)this.zzgrd, (Object)registerRequestParams.zzgrd);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzggo, this.zzgqz, this.zzgqy, this.zzgra, this.zzgrb, this.zzgrc, this.zzgrd});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzggo;
        private Double zzgqy;
        private Uri zzgqz;
        private List<RegisterRequest> zzgra;
        private List<RegisteredKey> zzgrb;
        private ChannelIdValue zzgrc;
        private String zzgrd;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzggo = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgqy = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgqz = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzgra = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgrb = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgrc = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgrd = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzggo, this.zzgqy, this.zzgqz, this.zzgra, this.zzgrb, this.zzgrc, this.zzgrd);
        }
    }
}

