/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgkh;
    private final Double zzgvw;
    private final Uri zzgvx;
    private final byte[] zzgwh;
    private final List<RegisteredKey> zzgvz;
    private final ChannelIdValue zzgwa;
    private final String zzgwb;
    private final Set<Uri> zzgwc;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzgkh = n;
        this.zzgvw = d;
        this.zzgvx = uri;
        this.zzgwh = byArray;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgvz = list;
        this.zzgwa = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbq.checkArgument((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbq.checkArgument((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgwc = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgwb = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgkh;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgvw;
    }

    @Override
    public Uri getAppId() {
        return this.zzgvx;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgwc;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgwh;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgvz;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgwa;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgwb;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgkh, (Object)signRequestParams.zzgkh) && zzbg.equal((Object)this.zzgvw, (Object)signRequestParams.zzgvw) && zzbg.equal((Object)this.zzgvx, (Object)signRequestParams.zzgvx) && Arrays.equals(this.zzgwh, signRequestParams.zzgwh) && this.zzgvz.containsAll(signRequestParams.zzgvz) && signRequestParams.zzgvz.containsAll(this.zzgvz) && zzbg.equal((Object)((Object)this.zzgwa), (Object)((Object)signRequestParams.zzgwa)) && zzbg.equal((Object)this.zzgwb, (Object)signRequestParams.zzgwb);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgkh, this.zzgvx, this.zzgvw, this.zzgvz, this.zzgwa, this.zzgwb, Arrays.hashCode(this.zzgwh)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgkh;
        private Double zzgvw;
        private Uri zzgvx;
        private byte[] zzgwh;
        private List<RegisteredKey> zzgvz;
        private ChannelIdValue zzgwa;
        private String zzgwb;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgkh = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgvw = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgvx = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgwh = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgvz = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgwa = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgwb = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzgkh, this.zzgvw, this.zzgvx, this.zzgwh, this.zzgvz, this.zzgwa, this.zzgwb);
        }
    }
}

