/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.util.zzb;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbej {
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzdzm;
    private final byte[] zzgvi;
    private final ProtocolVersion zzgvj;
    private final List<Transport> zzdmt;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzdzm = n;
        this.zzgvi = byArray;
        try {
            this.zzgvj = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdmt = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzdzm = 1;
        this.zzgvi = byArray;
        this.zzgvj = protocolVersion;
        this.zzdmt = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzdzm;
    }

    public byte[] getBytes() {
        return this.zzgvi;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzgvj;
    }

    public List<Transport> getTransports() {
        return this.zzdmt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbem.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzgvj.toString(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdmt == null ? "null" : this.zzdmt.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzb.zzj((byte[])this.zzgvi), this.zzgvj, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzgvi), this.zzgvj, this.zzdmt});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzgvi, keyHandle.zzgvi)) {
            return false;
        }
        if (!this.zzgvj.equals((Object)keyHandle.zzgvj)) {
            return false;
        }
        if (this.zzdmt == null && keyHandle.zzdmt == null) {
            return true;
        }
        if (this.zzdmt == null || keyHandle.zzdmt == null) {
            return false;
        }
        return this.zzdmt.containsAll(keyHandle.zzdmt) && keyHandle.zzdmt.containsAll(this.zzdmt);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzgvi != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzgvi, (int)11));
            }
            if (this.zzgvj != null) {
                jSONObject.put("version", (Object)this.zzgvj.toString());
            }
            if (this.zzdmt != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdmt) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

