/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgjx;
    private final Double zzgvm;
    private final Uri zzgvn;
    private final byte[] zzgvx;
    private final List<RegisteredKey> zzgvp;
    private final ChannelIdValue zzgvq;
    private final String zzgvr;
    private final Set<Uri> zzgvs;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzgjx = n;
        this.zzgvm = d;
        this.zzgvn = uri;
        this.zzgvx = byArray;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzgvp = list;
        this.zzgvq = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbq.checkArgument((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbq.checkArgument((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzgvs = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzgvr = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgjx;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzgvm;
    }

    @Override
    public Uri getAppId() {
        return this.zzgvn;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzgvs;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzgvx;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzgvp;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzgvq;
    }

    @Override
    public String getDisplayHint() {
        return this.zzgvr;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgjx, (Object)signRequestParams.zzgjx) && zzbg.equal((Object)this.zzgvm, (Object)signRequestParams.zzgvm) && zzbg.equal((Object)this.zzgvn, (Object)signRequestParams.zzgvn) && Arrays.equals(this.zzgvx, signRequestParams.zzgvx) && this.zzgvp.containsAll(signRequestParams.zzgvp) && signRequestParams.zzgvp.containsAll(this.zzgvp) && zzbg.equal((Object)((Object)this.zzgvq), (Object)((Object)signRequestParams.zzgvq)) && zzbg.equal((Object)this.zzgvr, (Object)signRequestParams.zzgvr);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgjx, this.zzgvn, this.zzgvm, this.zzgvp, this.zzgvq, this.zzgvr, Arrays.hashCode(this.zzgvx)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbem.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgjx;
        private Double zzgvm;
        private Uri zzgvn;
        private byte[] zzgvx;
        private List<RegisteredKey> zzgvp;
        private ChannelIdValue zzgvq;
        private String zzgvr;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgjx = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzgvm = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzgvn = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzgvx = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzgvp = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzgvq = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzgvr = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzgjx, this.zzgvm, this.zzgvn, this.zzgvx, this.zzgvp, this.zzgvq, this.zzgvr);
        }
    }
}

