/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.fido.common.zza;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public enum Transport implements ReflectedParcelable
{
    BLUETOOTH_CLASSIC("bt"),
    BLUETOOTH_LOW_ENERGY("ble"),
    NFC("nfc"),
    USB("usb");

    @Hide
    public static final Parcelable.Creator<Transport> CREATOR;
    private final String zza;

    private Transport(String string2) {
        this.zza = string2;
    }

    public static Transport fromString(String string) throws UnsupportedTransportException {
        for (Transport transport : Transport.values()) {
            if (!string.equals(transport.zza)) continue;
            return transport;
        }
        throw new UnsupportedTransportException(string);
    }

    public static List<Transport> parseTransports(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        HashSet<Transport> hashSet = new HashSet<Transport>(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string = jSONArray.getString(i);
            if (string == null || string.isEmpty()) continue;
            try {
                hashSet.add(Transport.fromString(string));
                continue;
            }
            catch (UnsupportedTransportException unsupportedTransportException) {
                String string2 = String.valueOf(string);
                Log.w((String)"Transport", (String)(string2.length() != 0 ? "Ignoring unrecognized transport ".concat(string2) : new String("Ignoring unrecognized transport ")));
            }
        }
        return new ArrayList<Transport>(hashSet);
    }

    public final String toString() {
        return this.zza;
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.zza);
    }

    static {
        CREATOR = new zza();
    }

    public static class UnsupportedTransportException
    extends Exception {
        public UnsupportedTransportException(String string) {
            super(String.format("Transport %s not supported", string));
        }
    }
}

