/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.fido2.api.common.BrowserRequestOptions;
import com.google.android.gms.fido.fido2.api.common.MakeCredentialOptions;
import com.google.android.gms.fido.fido2.api.common.RequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBindingIdValue;
import com.google.android.gms.fido.fido2.api.common.zzh;
import com.google.android.gms.internal.zzbgo;
import com.google.android.gms.internal.zzbgp;
import com.google.android.gms.internal.zzbgq;
import java.util.Arrays;

public class BrowserMakeCredentialOptions
extends BrowserRequestOptions {
    @Hide
    public static final Parcelable.Creator<BrowserMakeCredentialOptions> CREATOR = new zzh();
    private final MakeCredentialOptions zza;
    private final Uri zzb;

    BrowserMakeCredentialOptions(MakeCredentialOptions makeCredentialOptions, Uri uri) {
        this.zza = (MakeCredentialOptions)((Object)zzbq.zza((Object)((Object)makeCredentialOptions)));
        zzbq.zza((Object)uri);
        zzbq.zzb((uri.getScheme() != null ? 1 : 0) != 0, (Object)"origin scheme must be non-empty");
        zzbq.zzb((uri.getAuthority() != null ? 1 : 0) != 0, (Object)"origin authority must be non-empty");
        this.zzb = uri;
    }

    public static BrowserMakeCredentialOptions deserializeFromBytes(byte[] byArray) {
        return (BrowserMakeCredentialOptions)zzbgq.zza((byte[])byArray, CREATOR);
    }

    @Override
    public byte[] serializeToBytes() {
        return zzbgq.zza((zzbgp)this);
    }

    public MakeCredentialOptions getMakeCredentialOptions() {
        return this.zza;
    }

    @Override
    public byte[] getChallenge() {
        return ((RequestOptions)this.zza).getChallenge();
    }

    @Override
    public Double getTimeoutSeconds() {
        return ((RequestOptions)this.zza).getTimeoutSeconds();
    }

    @Override
    public Integer getRequestId() {
        return ((RequestOptions)this.zza).getRequestId();
    }

    @Override
    public TokenBindingIdValue getTokenBindingIdValue() {
        return ((RequestOptions)this.zza).getTokenBindingIdValue();
    }

    @Override
    public Uri getOrigin() {
        return this.zzb;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        BrowserMakeCredentialOptions browserMakeCredentialOptions = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Parcelable)browserMakeCredentialOptions.getMakeCredentialOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Parcelable)((BrowserRequestOptions)browserMakeCredentialOptions).getOrigin(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        BrowserMakeCredentialOptions browserMakeCredentialOptions = (BrowserMakeCredentialOptions)((Object)object);
        return zzbg.zza((Object)((Object)this.zza), (Object)((Object)browserMakeCredentialOptions.zza)) && zzbg.zza((Object)this.zzb, (Object)browserMakeCredentialOptions.zzb);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzb});
    }

    public static final class Builder {
        private MakeCredentialOptions zza;
        private Uri zzb;

        public Builder() {
        }

        public final Builder setMakeCredentialOptions(MakeCredentialOptions makeCredentialOptions) {
            this.zza = makeCredentialOptions;
            return this;
        }

        public final Builder setOrigin(Uri uri) {
            this.zzb = uri;
            return this;
        }

        public final BrowserMakeCredentialOptions build() {
            return new BrowserMakeCredentialOptions(this.zza, this.zzb);
        }
    }
}

