/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zza;
    private final byte[] zzb;
    private final ProtocolVersion zzc;
    private final List<Transport> zzd;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zza = n;
        this.zzb = byArray;
        try {
            this.zzc = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzd = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zza = 1;
        this.zzb = byArray;
        this.zzc = protocolVersion;
        this.zzd = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zza;
    }

    public byte[] getBytes() {
        return this.zzb;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzc;
    }

    public List<Transport> getTransports() {
        return this.zzd;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbgo.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzc.toString(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzd == null ? "null" : this.zzd.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{com.google.android.gms.common.util.zzc.zza((byte[])this.zzb), this.zzc, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzb), this.zzc, this.zzd});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzb, keyHandle.zzb)) {
            return false;
        }
        if (!this.zzc.equals((Object)keyHandle.zzc)) {
            return false;
        }
        if (this.zzd == null && keyHandle.zzd == null) {
            return true;
        }
        if (this.zzd == null || keyHandle.zzd == null) {
            return false;
        }
        return this.zzd.containsAll(keyHandle.zzd) && keyHandle.zzd.containsAll(this.zzd);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzb != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzb, (int)11));
            }
            if (this.zzc != null) {
                jSONObject.put("version", (Object)this.zzc.toString());
            }
            if (this.zzd != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzd) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

