/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzi;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public class RegisterRequest
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<RegisterRequest> CREATOR = new zzi();
    public static final int U2F_V1_CHALLENGE_BYTE_LENGTH = 65;
    private final int zza;
    private final ProtocolVersion zzb;
    private final byte[] zzc;
    private final String zzd;

    RegisterRequest(int n, String string, byte[] byArray, String string2) {
        this.zza = n;
        try {
            this.zzb = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzc = byArray;
        this.zzd = string2;
    }

    public RegisterRequest(ProtocolVersion protocolVersion, byte[] byArray, String string) {
        this.zza = 1;
        this.zzb = (ProtocolVersion)((Object)zzbq.zza((Object)((Object)protocolVersion)));
        this.zzc = (byte[])zzbq.zza((Object)byArray);
        if (protocolVersion == ProtocolVersion.V1) {
            zzbq.zzb((byArray.length == 65 ? 1 : 0) != 0, (Object)"invalid challengeValue length for V1");
        }
        this.zzd = string;
    }

    public static RegisterRequest parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("challenge");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        String string3 = null;
        if (jSONObject.has("appId")) {
            string3 = jSONObject.getString("appId");
        }
        try {
            return new RegisterRequest(protocolVersion, byArray, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.getMessage());
        }
    }

    public int getVersionCode() {
        return this.zza;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzb;
    }

    public byte[] getChallengeValue() {
        return this.zzc;
    }

    public String getAppId() {
        return this.zzd;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequest registerRequest = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (int)registerRequest.getVersionCode());
        zzbgo.zza((Parcel)parcel2, (int)2, (String)registerRequest.zzb.toString(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (byte[])registerRequest.getChallengeValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (String)registerRequest.getAppId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        int n = 31 + Arrays.hashCode(this.zzc);
        n = n * 31 + this.zzb.hashCode();
        return n * 31 + (this.zzd == null ? 0 : this.zzd.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequest registerRequest = (RegisterRequest)((Object)object);
        if (!Arrays.equals(this.zzc, registerRequest.zzc)) {
            return false;
        }
        if (this.zzb != registerRequest.zzb) {
            return false;
        }
        return !(this.zzd == null ? registerRequest.zzd != null : !this.zzd.equals(registerRequest.zzd));
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("version", (Object)this.zzb.toString());
            jSONObject.put("challenge", (Object)Base64.encodeToString((byte[])this.zzc, (int)11));
            if (this.zzd != null) {
                jSONObject.put("appId", (Object)this.zzd);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

