/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    @Hide
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zza;
    private final Double zzb;
    private final Uri zzc;
    private final byte[] zzd;
    private final List<RegisteredKey> zze;
    private final ChannelIdValue zzf;
    private final String zzg;
    private final Set<Uri> zzh;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zza = n;
        this.zzb = d;
        this.zzc = uri;
        this.zzd = byArray;
        zzbq.zzb((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zze = list;
        this.zzf = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbq.zzb((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbq.zzb((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzh = hashSet;
        zzbq.zzb((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzg = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zza;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzb;
    }

    @Override
    public Uri getAppId() {
        return this.zzc;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzh;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzd;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zze;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzf;
    }

    @Override
    public String getDisplayHint() {
        return this.zzg;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbg.zza((Object)this.zza, (Object)signRequestParams.zza) && zzbg.zza((Object)this.zzb, (Object)signRequestParams.zzb) && zzbg.zza((Object)this.zzc, (Object)signRequestParams.zzc) && Arrays.equals(this.zzd, signRequestParams.zzd) && this.zze.containsAll(signRequestParams.zze) && signRequestParams.zze.containsAll(this.zze) && zzbg.zza((Object)((Object)this.zzf), (Object)((Object)signRequestParams.zzf)) && zzbg.zza((Object)this.zzg, (Object)signRequestParams.zzg);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zza, this.zzc, this.zzb, this.zze, this.zzf, this.zzg, Arrays.hashCode(this.zzd)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zza;
        private Double zzb;
        private Uri zzc;
        private byte[] zzd;
        private List<RegisteredKey> zze;
        private ChannelIdValue zzf;
        private String zzg;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zza = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzb = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzc = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzd = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zze = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzf = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzg = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg);
        }
    }
}

