/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyHandle
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<KeyHandle> CREATOR = new zzg();
    private final int zzehz;
    private final byte[] zzhgi;
    private final ProtocolVersion zzhgj;
    private final List<Transport> zzdvg;

    KeyHandle(int n, byte[] byArray, String string, List<Transport> list) {
        this.zzehz = n;
        this.zzhgi = byArray;
        try {
            this.zzhgj = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzdvg = list;
    }

    public KeyHandle(byte[] byArray, ProtocolVersion protocolVersion, List<Transport> list) {
        this.zzehz = 1;
        this.zzhgi = byArray;
        this.zzhgj = protocolVersion;
        this.zzdvg = list;
    }

    public static KeyHandle parseFromJson(JSONObject jSONObject) throws JSONException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        String string = null;
        if (jSONObject.has("version")) {
            string = jSONObject.getString("version");
        }
        try {
            protocolVersion = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        String string2 = jSONObject.getString("keyHandle");
        try {
            byArray = Base64.decode((String)string2, (int)8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        JSONObject jSONObject2 = jSONObject;
        List<Transport> list = !jSONObject2.has("transports") ? null : Transport.parseTransports(jSONObject2.getJSONArray("transports"));
        return new KeyHandle(byArray, protocolVersion, list);
    }

    public int getVersionCode() {
        return this.zzehz;
    }

    public byte[] getBytes() {
        return this.zzhgi;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.zzhgj;
    }

    public List<Transport> getTransports() {
        return this.zzdvg;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        KeyHandle keyHandle = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zzc((Parcel)parcel2, (int)1, (int)keyHandle.getVersionCode());
        zzbgo.zza((Parcel)parcel2, (int)2, (byte[])keyHandle.getBytes(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)keyHandle.zzhgj.toString(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)4, keyHandle.getTransports(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        String string = this.zzdvg == null ? "null" : this.zzdvg.toString();
        return String.format("{keyHandle: %s, version: %s, transports: %s}", new Object[]{zzc.zzj((byte[])this.zzhgi), this.zzhgj, string});
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{Arrays.hashCode(this.zzhgi), this.zzhgj, this.zzdvg});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        KeyHandle keyHandle = (KeyHandle)((Object)object);
        if (!Arrays.equals(this.zzhgi, keyHandle.zzhgi)) {
            return false;
        }
        if (!this.zzhgj.equals((Object)keyHandle.zzhgj)) {
            return false;
        }
        if (this.zzdvg == null && keyHandle.zzdvg == null) {
            return true;
        }
        if (this.zzdvg == null || keyHandle.zzdvg == null) {
            return false;
        }
        return this.zzdvg.containsAll(keyHandle.zzdvg) && keyHandle.zzdvg.containsAll(this.zzdvg);
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.zzhgi != null) {
                jSONObject.put("keyHandle", (Object)Base64.encodeToString((byte[])this.zzhgi, (int)11));
            }
            if (this.zzhgj != null) {
                jSONObject.put("version", (Object)this.zzhgj.toString());
            }
            if (this.zzdvg != null) {
                JSONArray jSONArray = new JSONArray();
                for (Transport transport : this.zzdvg) {
                    jSONArray.put((Object)transport.toString());
                }
                jSONObject.put("transports", (Object)jSONArray);
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        return jSONObject;
    }
}

