/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzj;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RegisterRequestParams
extends RequestParams {
    @Hide
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzj();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgtd;
    private final Double zzhfe;
    private final Uri zzhgm;
    private final List<RegisterRequest> zzhgn;
    private final List<RegisteredKey> zzhgo;
    private final ChannelIdValue zzhgp;
    private final String zzhgq;
    private Set<Uri> zzhgr;

    RegisterRequestParams(Integer n, Double d, Uri uri, List<RegisterRequest> list, List<RegisteredKey> list2, ChannelIdValue channelIdValue, String string) {
        this.zzgtd = n;
        this.zzhfe = d;
        this.zzhgm = uri;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"empty list of register requests is provided");
        this.zzhgn = list;
        this.zzhgo = list2;
        this.zzhgp = channelIdValue;
        List<RegisteredKey> list3 = this.zzhgo;
        List<RegisterRequest> list4 = this.zzhgn;
        Uri uri2 = this.zzhgm;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisterRequest zzbgl2 : list4) {
            zzbq.checkArgument((uri2 != null || zzbgl2.getAppId() != null ? 1 : 0) != 0, (Object)"register request has null appId and no request appId is provided");
            if (zzbgl2.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)zzbgl2.getAppId()));
        }
        for (RegisteredKey registeredKey : list3) {
            zzbq.checkArgument((uri2 != null || registeredKey.getAppId() != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzhgr = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzhgq = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgtd;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzhfe;
    }

    @Override
    public Uri getAppId() {
        return this.zzhgm;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzhgr;
    }

    public List<RegisterRequest> getRegisterRequests() {
        return this.zzhgn;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzhgo;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzhgp;
    }

    @Override
    public String getDisplayHint() {
        return this.zzhgq;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        RegisterRequestParams registerRequestParams = (RegisterRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgtd, (Object)registerRequestParams.zzgtd) && zzbg.equal((Object)this.zzhfe, (Object)registerRequestParams.zzhfe) && zzbg.equal((Object)this.zzhgm, (Object)registerRequestParams.zzhgm) && zzbg.equal(this.zzhgn, registerRequestParams.zzhgn) && (this.zzhgo == null && registerRequestParams.zzhgo == null || this.zzhgo != null && registerRequestParams.zzhgo != null && this.zzhgo.containsAll(registerRequestParams.zzhgo) && registerRequestParams.zzhgo.containsAll(this.zzhgo)) && zzbg.equal((Object)((Object)this.zzhgp), (Object)((Object)registerRequestParams.zzhgp)) && zzbg.equal((Object)this.zzhgq, (Object)registerRequestParams.zzhgq);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgtd, this.zzhgm, this.zzhfe, this.zzhgn, this.zzhgo, this.zzhgp, this.zzhgq});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RegisterRequestParams registerRequestParams = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)registerRequestParams).getRequestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)registerRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)registerRequestParams).getAppId(), (int)n, (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)5, registerRequestParams.getRegisterRequests(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, ((RequestParams)registerRequestParams).getRegisteredKeys(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)registerRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)((RequestParams)registerRequestParams).getDisplayHint(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgtd;
        private Double zzhfe;
        private Uri zzhgm;
        private List<RegisterRequest> zzhgn;
        private List<RegisteredKey> zzhgo;
        private ChannelIdValue zzhgp;
        private String zzhgq;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgtd = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzhfe = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzhgm = uri;
            return this;
        }

        public final Builder setRegisterRequests(List<RegisterRequest> list) {
            this.zzhgn = list;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzhgo = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzhgp = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzhgq = string;
            return this;
        }

        public final RegisterRequestParams build() {
            return new RegisterRequestParams(this.zzgtd, this.zzhfe, this.zzhgm, this.zzhgn, this.zzhgo, this.zzhgp, this.zzhgq);
        }
    }
}

