/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzm;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignRequestParams
extends RequestParams {
    @Hide
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzm();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    private final Integer zzgtd;
    private final Double zzhfe;
    private final Uri zzhgm;
    private final byte[] zzhgw;
    private final List<RegisteredKey> zzhgo;
    private final ChannelIdValue zzhgp;
    private final String zzhgq;
    private final Set<Uri> zzhgr;

    SignRequestParams(Integer n, Double d, Uri uri, byte[] byArray, List<RegisteredKey> list, ChannelIdValue channelIdValue, String string) {
        this.zzgtd = n;
        this.zzhfe = d;
        this.zzhgm = uri;
        this.zzhgw = byArray;
        zzbq.checkArgument((list != null && !list.isEmpty() ? 1 : 0) != 0, (Object)"registeredKeys must not be null or empty");
        this.zzhgo = list;
        this.zzhgp = channelIdValue;
        List<RegisteredKey> list2 = list;
        Uri uri2 = uri;
        HashSet<Uri> hashSet = new HashSet<Uri>();
        if (uri2 != null) {
            hashSet.add(uri2);
        }
        for (RegisteredKey registeredKey : list2) {
            zzbq.checkArgument((registeredKey.getAppId() != null || uri2 != null ? 1 : 0) != 0, (Object)"registered key has null appId and no request appId is provided");
            zzbq.checkArgument((registeredKey.getChallengeValue() != null || list2 != null ? 1 : 0) != 0, (Object)"register request has null challenge and no default challenge isprovided");
            if (registeredKey.getAppId() == null) continue;
            hashSet.add(Uri.parse((String)registeredKey.getAppId()));
        }
        this.zzhgr = hashSet;
        zzbq.checkArgument((string == null || string.length() <= 80 ? 1 : 0) != 0, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzhgq = string;
    }

    @Override
    public Integer getRequestId() {
        return this.zzgtd;
    }

    @Override
    public Double getTimeoutSeconds() {
        return this.zzhfe;
    }

    @Override
    public Uri getAppId() {
        return this.zzhgm;
    }

    @Override
    public Set<Uri> getAllAppIds() {
        return this.zzhgr;
    }

    public byte[] getDefaultSignChallenge() {
        return this.zzhgw;
    }

    @Override
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zzhgo;
    }

    @Override
    public ChannelIdValue getChannelIdValue() {
        return this.zzhgp;
    }

    @Override
    public String getDisplayHint() {
        return this.zzhgq;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SignRequestParams signRequestParams = (SignRequestParams)((Object)object);
        return zzbg.equal((Object)this.zzgtd, (Object)signRequestParams.zzgtd) && zzbg.equal((Object)this.zzhfe, (Object)signRequestParams.zzhfe) && zzbg.equal((Object)this.zzhgm, (Object)signRequestParams.zzhgm) && Arrays.equals(this.zzhgw, signRequestParams.zzhgw) && this.zzhgo.containsAll(signRequestParams.zzhgo) && signRequestParams.zzhgo.containsAll(this.zzhgo) && zzbg.equal((Object)((Object)this.zzhgp), (Object)((Object)signRequestParams.zzhgp)) && zzbg.equal((Object)this.zzhgq, (Object)signRequestParams.zzhgq);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzgtd, this.zzhgm, this.zzhfe, this.zzhgo, this.zzhgp, this.zzhgq, Arrays.hashCode(this.zzhgw)});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        SignRequestParams signRequestParams = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (Integer)((RequestParams)signRequestParams).getRequestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (Double)((RequestParams)signRequestParams).getTimeoutSeconds(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)((RequestParams)signRequestParams).getAppId(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (byte[])signRequestParams.getDefaultSignChallenge(), (boolean)false);
        zzbgo.zzc((Parcel)parcel2, (int)6, ((RequestParams)signRequestParams).getRegisteredKeys(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)((RequestParams)signRequestParams).getChannelIdValue(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (String)((RequestParams)signRequestParams).getDisplayHint(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private Integer zzgtd;
        private Double zzhfe;
        private Uri zzhgm;
        private byte[] zzhgw;
        private List<RegisteredKey> zzhgo;
        private ChannelIdValue zzhgp;
        private String zzhgq;

        public Builder() {
        }

        public final Builder setRequestId(Integer n) {
            this.zzgtd = n;
            return this;
        }

        public final Builder setTimeoutSeconds(Double d) {
            this.zzhfe = d;
            return this;
        }

        public final Builder setAppId(Uri uri) {
            this.zzhgm = uri;
            return this;
        }

        public final Builder setDefaultSignChallenge(byte[] byArray) {
            this.zzhgw = byArray;
            return this;
        }

        public final Builder setRegisteredKeys(List<RegisteredKey> list) {
            this.zzhgo = list;
            return this;
        }

        public final Builder setChannelIdValue(ChannelIdValue channelIdValue) {
            this.zzhgp = channelIdValue;
            return this;
        }

        public final Builder setDisplayHint(String string) {
            this.zzhgq = string;
            return this;
        }

        public final SignRequestParams build() {
            return new SignRequestParams(this.zzgtd, this.zzhfe, this.zzhgm, this.zzhgw, this.zzhgo, this.zzhgp, this.zzhgq);
        }
    }
}

