/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisterRequest;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzh;
import java.util.List;
import java.util.Set;

@Deprecated
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RegisterRequestParamsCreator")
public class RegisterRequestParams
extends RequestParams {
    @NonNull
    public static final Parcelable.Creator<RegisterRequestParams> CREATOR = new zzh();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    @SafeParcelable.Field(id=2, getter="getRequestId")
    private final Integer zza;
    @SafeParcelable.Field(id=3, getter="getTimeoutSeconds")
    private final Double zzb;
    @SafeParcelable.Field(id=4, getter="getAppId")
    private final Uri zzc;
    @SafeParcelable.Field(id=5, getter="getRegisterRequests")
    private final List zzd;
    @SafeParcelable.Field(id=6, getter="getRegisteredKeys")
    private final List zze;
    @SafeParcelable.Field(id=7, getter="getChannelIdValue")
    private final ChannelIdValue zzf;
    @SafeParcelable.Field(id=8, getter="getDisplayHint")
    private final String zzg;
    private Set zzh;

    public int hashCode() {
        Integer n = this.zza;
        return Objects.hashCode((Object[])new Object[]{n, this.zzc, this.zzb, this.zzd, this.zze, this.zzf, this.zzg});
    }

    @Override
    @NonNull
    public Uri getAppId() {
        return this.zzc;
    }

    @Override
    @NonNull
    public ChannelIdValue getChannelIdValue() {
        return this.zzf;
    }

    @Override
    @NonNull
    public Double getTimeoutSeconds() {
        return this.zzb;
    }

    @Override
    @NonNull
    public Integer getRequestId() {
        return this.zza;
    }

    @Override
    @NonNull
    public String getDisplayHint() {
        return this.zzg;
    }

    @NonNull
    public List<RegisterRequest> getRegisterRequests() {
        return this.zzd;
    }

    @Override
    @NonNull
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zze;
    }

    @Override
    @NonNull
    public Set<Uri> getAllAppIds() {
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    RegisterRequestParams(@SafeParcelable.Param(id=2) Integer n, @SafeParcelable.Param(id=3) Double d, @SafeParcelable.Param(id=4) Uri object, @SafeParcelable.Param(id=5) List collection, @SafeParcelable.Param(id=6) List object2, @SafeParcelable.Param(id=7) ChannelIdValue abstractSafeParcelable2, @SafeParcelable.Param(id=8) String string) {
        this.zza = n;
        this.zzb = d;
        this.zzc = object;
        boolean bl = collection != null ? !collection.isEmpty() : false;
        Preconditions.checkArgument((boolean)bl, (Object)"empty list of register requests is provided");
        this.zzd = collection;
        this.zze = object2;
        this.zzf = abstractSafeParcelable2;
        d = this.zzc;
        List list = this.zzd;
        object = this.zze;
        if (d != null) {
            collection.add((Uri)d);
        }
        for (AbstractSafeParcelable abstractSafeParcelable2 : list) {
            boolean bl2 = d == null ? abstractSafeParcelable2.getAppId() != null : true;
            Preconditions.checkArgument((boolean)bl2, (Object)"register request has null appId and no request appId is provided");
            if (abstractSafeParcelable2.getAppId() == null) continue;
            collection.add(Uri.parse((String)abstractSafeParcelable2.getAppId()));
        }
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (RegisteredKey)((Object)object.next());
            boolean bl3 = d == null ? ((RegisteredKey)((Object)object2)).getAppId() != null : true;
            Preconditions.checkArgument((boolean)bl3, (Object)"registered key has null appId and no request appId is provided");
            if (((RegisteredKey)((Object)object2)).getAppId() == null) continue;
            collection.add(Uri.parse((String)((RegisteredKey)((Object)object2)).getAppId()));
        }
        this.zzh = collection;
        boolean bl4 = string != null ? string.length() <= 80 : true;
        Preconditions.checkArgument((boolean)bl4, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzg = string;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)2, (Integer)this.getRequestId(), (boolean)false);
        SafeParcelWriter.writeDoubleObject((Parcel)var1_1, (int)3, (Double)this.getTimeoutSeconds(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getAppId(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)5, this.getRegisterRequests(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)6, this.getRegisteredKeys(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getChannelIdValue(), (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)8, (String)this.getDisplayHint(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@NonNull Object o) {
        List list;
        List list2;
        RegisterRequestParams registerRequestParams;
        if (this == registerRequestParams) {
            return true;
        }
        if (!(registerRequestParams instanceof RegisterRequestParams)) {
            return false;
        }
        registerRequestParams = registerRequestParams;
        return Objects.equal((Object)this.zza, (Object)registerRequestParams.zza) && Objects.equal((Object)this.zzb, (Object)registerRequestParams.zzb) && Objects.equal((Object)this.zzc, (Object)registerRequestParams.zzc) && Objects.equal((Object)this.zzd, (Object)registerRequestParams.zzd) && ((list2 = this.zze) == null && registerRequestParams.zze == null || list2 != null && (list = registerRequestParams.zze) != null && list2.containsAll(list) && registerRequestParams.zze.containsAll(this.zze)) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)registerRequestParams.zzf)) && Objects.equal((Object)this.zzg, (Object)registerRequestParams.zzg);
    }

    public static final class Builder {
        Integer zza;
        Double zzb;
        Uri zzc;
        List zzd;
        List zze;
        ChannelIdValue zzf;
        String zzg;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAppId(@NonNull Uri appId) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setChannelIdValue(@NonNull ChannelIdValue channelIdValue) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDisplayHint(@NonNull String displayHint) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRegisterRequests(@NonNull List<RegisterRequest> registerRequests) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRegisteredKeys(@NonNull List<RegisteredKey> registeredKeys) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@NonNull Integer requestId) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeoutSeconds(@NonNull Double timeoutSeconds) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public RegisterRequestParams build() {
            return new RegisterRequestParams(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg);
        }
    }
}

